/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.nodematcher;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.AttributeMatcher;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="All nodes with specified attribute value", order=190)
public class HasAttributeValueMatcher
extends AttributeMatcher {
    private static final long serialVersionUID = 1L;
    private Operator operator;
    private String value;

    public HasAttributeValueMatcher() {
    }

    public HasAttributeValueMatcher(String attributeName, Operator operator, String value) {
        this.setAttribute(attributeName);
        this.operator = operator;
        this.value = value;
    }

    public HasAttributeValueMatcher(Operator operator, String value) {
        this.operator = operator;
        this.value = value;
    }

    @Editable(order=20)
    @NotNull
    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Editable(order=30, description="Specify expected value here. In case of operator <em>matches_regular_expression</em>, this field expects a <a href=\"http://java.sun.com/j2se/1.4.2/docs/api/java/util/regex/Pattern.html\">Java regular expression pattern</a>.")
    @NotEmpty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean matches(GridNode node) {
        return this.getOperator().isSatisfied(node.getAttribute(this.getAttribute(), ""), this.getValue());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HasAttributeValueMatcher)) {
            return false;
        }
        HasAttributeValueMatcher rhs = (HasAttributeValueMatcher)other;
        return super.equals(rhs) && Objects.equal((Object)((Object)this.operator), (Object)((Object)rhs.operator)) && Objects.equal((Object)this.value, (Object)rhs.value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.operator, this.value});
    }

    public String toString() {
        return "attribute [" + this.getAttribute() + "] value " + (Object)((Object)this.operator) + " [" + this.getValue() + "]";
    }

    @Override
    public String getName() {
        return "HAS_ATTRIBUTE_VALUE";
    }

    @Override
    public String toHtml() {
        return "attribute <code>" + this.getAttribute() + "</code> with value <code>" + this.getValue() + "</code></b>";
    }

    @Override
    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.getAttribute()) && !Strings.isNullOrEmpty((String)this.value);
    }

    public static enum Operator {
        equals{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.equals(expected);
            }
        }
        ,
        equals_ignore_case{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.equalsIgnoreCase(expected);
            }
        }
        ,
        contains{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.contains(expected);
            }
        }
        ,
        matches_regular_expression{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.matches(expected);
            }
        }
        ,
        begin_with{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.startsWith(expected);
            }
        }
        ,
        ends_with{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.endsWith(expected);
            }
        };


        public abstract boolean isSatisfied(String var1, String var2);
    }
}

