/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.nodematcher;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcher;
import com.pmease.quickbuild.plugin.alert.engine.nodematcher.NodeMatcherCriteria;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="Nodes matching all specified criterias", order=210)
public class AndMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private List<NodeMatcherCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<NodeMatcherCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<NodeMatcherCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean matches(GridNode node) {
        for (NodeMatcherCriteria each : this.getCriterias()) {
            if (each.getCriteria().matches(node)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AndMatcher)) {
            return false;
        }
        AndMatcher rhs = (AndMatcher)other;
        return Objects.equal(this.criterias, rhs.criterias);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.criterias});
    }

    public String toString() {
        ArrayList list = Lists.newArrayList();
        for (NodeMatcherCriteria each : this.criterias) {
            boolean b = this.criterias.size() > 0;
            StringBuffer sb = new StringBuffer();
            if (b) {
                sb.append("(");
            }
            sb.append(each.toString());
            if (b) {
                sb.append(")");
            }
            list.add(sb.toString());
        }
        return Joiner.on((String)" and ").join((Iterable)list);
    }

    @Override
    public String toHtml() {
        boolean b;
        StringBuffer sb = new StringBuffer();
        boolean bl = b = this.criterias.size() > 1;
        if (b) {
            sb.append("<ul class='square'>");
        }
        int i = 0;
        for (NodeMatcherCriteria each : this.criterias) {
            if (b) {
                sb.append("<li>");
            }
            sb.append("<span>").append(each.toHtml()).append("</span>");
            if (i + 1 < this.criterias.size()) {
                sb.append("<span> and </span>");
            }
            if (!b) continue;
            sb.append("</li>");
        }
        if (b) {
            sb.append("</ul>");
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return "AND";
    }

    @Override
    public boolean isValid() {
        for (NodeMatcherCriteria each : this.criterias) {
            if (each.isValid()) continue;
            return false;
        }
        return true;
    }
}

