/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.gadget;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.entitymanager.AlertManager;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinition;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertSetting;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.alert.engine.web.components.PriorityLabel;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AlertTableBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String source;
    private Alert.AlertPriority priority;
    private String definition;
    private TimeSpan timespan;
    private List<ColumnType> columns;
    private int maxRows;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Alert.AlertPriority getPriority() {
        return this.priority;
    }

    public void setPriority(Alert.AlertPriority priority) {
        this.priority = priority;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public TimeSpan getTimespan() {
        return this.timespan;
    }

    public void setTimespan(TimeSpan timespan) {
        this.timespan = timespan;
    }

    public List<ColumnType> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnType> columns) {
        this.columns = columns;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public static List<String> getAvailableColumns() {
        return ImmutableList.of((Object)"All", (Object)"Priority", (Object)"Subject", (Object)"Trigger", (Object)"Condition Test", (Object)"Alert Message", (Object)"Creation Time");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AlertTableBuilder)) {
            return false;
        }
        AlertTableBuilder rhs = (AlertTableBuilder)other;
        return Objects.equal((Object)this.source, (Object)rhs.source) && Objects.equal((Object)this.priority, (Object)rhs.priority) && Objects.equal((Object)this.definition, (Object)rhs.definition) && Objects.equal(this.columns, rhs.columns) && Objects.equal((Object)this.maxRows, (Object)rhs.maxRows);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.source, this.priority, this.definition, this.columns, this.maxRows});
    }

    public static enum ColumnType {
        PRIORITY("Priority"){

            @Override
            public IColumn<Long> createColumn() {
                return new EntityColumn(Alert.class, "priority", true){

                    protected Component createItemComponent(String componentId, IModel<Long> rowModel) {
                        Alert alert = (Alert)AlertManager.instance.load((Long)rowModel.getObject());
                        Alert.AlertPriority priority = alert.getPriority();
                        return new PriorityLabel(componentId, priority);
                    }
                }.setCssClass("enum");
            }
        }
        ,
        SUBJECT("Subject"){

            @Override
            public IColumn<Long> createColumn() {
                return new EntityColumn(Alert.class, "subject", true).setCssClass("nowrap-text");
            }
        }
        ,
        TRIGGER("Trigger"){

            @Override
            public IColumn<Long> createColumn() {
                return new EntityColumn(Alert.class, "trigger", true).setCssClass("nowrap-text");
            }
        }
        ,
        CONDITION_TEST("Condition Test"){

            @Override
            public IColumn<Long> createColumn() {
                return new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Condition Test"))){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<ICellPopulator<Long>> item, String componentId, IModel<Long> rowModel) {
                        Long id = (Long)rowModel.getObject();
                        Alert alert = (Alert)AlertManager.instance.load(id);
                        if (alert.getCategory() != Alert.AlertCategory.METRIC) {
                            item.add(new Component[]{new Label(componentId, "")});
                        } else {
                            AlertSetting setting = AlertSetting.get();
                            AlertDefinition def = setting.getDefinition(alert.getSubject());
                            item.add(new Component[]{new Label(componentId, def == null ? "" : def.getCondition().toString())});
                        }
                    }

                    public String getCssClass() {
                        return "text";
                    }
                };
            }
        }
        ,
        ALERT_MESSAGE("Alert Message"){

            @Override
            public IColumn<Long> createColumn() {
                return new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Alert Message"))){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<ICellPopulator<Long>> item, String id, IModel<Long> rowModel) {
                        Alert alert = (Alert)AlertManager.instance.load((Long)rowModel.getObject());
                        String msg = alert.getAlertMessage();
                        item.add(new Component[]{new Label(id, msg)});
                    }

                    public String getCssClass() {
                        return "text";
                    }
                };
            }
        }
        ,
        CREATION_TIME("Creation Time"){

            @Override
            public IColumn<Long> createColumn() {
                return new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Creation Time")), "ctime"){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<ICellPopulator<Long>> item, String id, IModel<Long> rowModel) {
                        Alert alert = (Alert)AlertManager.instance.load((Long)rowModel.getObject());
                        item.add(new Component[]{new Label(id, DataTypes.DATE.asString((Object)new Date(alert.getCtime()), "MMM dd, yyyy HH:mm:ss"))});
                    }

                    public String getCssClass() {
                        return "nowrap-text";
                    }
                };
            }
        };

        private final String displayName;

        private ColumnType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public abstract IColumn<Long> createColumn();

        public static ColumnType fromDisplayName(String displayName) {
            for (ColumnType each : ColumnType.values()) {
                if (!Objects.equal((Object)displayName, (Object)each.displayName)) continue;
                return each;
            }
            return null;
        }
    }
}

