/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.gadget;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.plugin.alert.engine.gadget.AlertTableBuilder;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.datatablesupport.EntityDataTable;
import com.pmease.quickbuild.web.component.datatablesupport.FilterableEntityProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AlertGadgetPanel
extends Panel {
    private final AlertTableBuilder builder;

    public AlertGadgetPanel(String id, AlertTableBuilder builder) {
        super(id);
        this.builder = builder;
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        if (!SecurityHelper.isViewAlertsAllowed()) {
            this.add(new Component[]{new Fragment("content", "nopermission", (MarkupContainer)this)});
        } else {
            Fragment frag = new Fragment("content", "records", (MarkupContainer)this);
            frag.add(new Component[]{this.createAlertsTable("alerts")});
            this.add(new Component[]{frag});
        }
    }

    private Component createAlertsTable(String id) {
        FilterableEntityProvider provider = new FilterableEntityProvider(Alert.class, new SortParam("ctime", false), new String[]{"subject", "trigger"}){

            public Criterion[] getCriterions() {
                Object[] crits;
                ArrayList list = Lists.newArrayList();
                TimeSpan timespan = AlertGadgetPanel.this.builder.getTimespan();
                Range<Long> range = timespan.range();
                list.add(Restrictions.ge((String)"ctime", (Object)range.lowerEndpoint()));
                list.add(Restrictions.le((String)"ctime", (Object)range.upperEndpoint()));
                if (AlertGadgetPanel.this.builder.getPriority() != null) {
                    list.add(Restrictions.eq((String)"priority", (Object)AlertGadgetPanel.this.builder.getPriority()));
                }
                if (!Strings.isNullOrEmpty((String)AlertGadgetPanel.this.builder.getSource())) {
                    list.add(Restrictions.eq((String)"trigger", (Object)AlertGadgetPanel.this.builder.getSource()));
                }
                if (!Strings.isNullOrEmpty((String)AlertGadgetPanel.this.builder.getDefinition())) {
                    list.add(Restrictions.eq((String)"subject", (Object)AlertGadgetPanel.this.builder.getDefinition()));
                }
                if ((crits = super.getCriterions()) != null) {
                    list.addAll(Lists.newArrayList((Object[])crits));
                }
                return (Criterion[])Iterables.toArray((Iterable)list, Criterion.class);
            }
        };
        EntityDataTable dataTable = new EntityDataTable(id, this.getTableColumns(), provider, this.builder.getMaxRows());
        dataTable.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataTable, (ISortStateLocator)provider));
        return dataTable;
    }

    private List<IColumn<Long>> getTableColumns() {
        ArrayList columns = Lists.newArrayList();
        List<AlertTableBuilder.ColumnType> types = this.builder.getColumns();
        for (AlertTableBuilder.ColumnType each : types) {
            columns.add(each.createColumn());
        }
        return columns;
    }
}

