/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine.gadget;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.plugin.alert.engine.gadget.AlertGadgetPanel;
import com.pmease.quickbuild.plugin.alert.engine.gadget.AlertTableBuilder;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinition;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertSetting;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="System Alerts", category={"Grid Measurements & Alerts"})
public class AlertGadget
extends Gadget {
    private static final long serialVersionUID = 1L;
    private String source = "All";
    private String priority = "All";
    private String definition = "All";
    private String timespan = TimeSpan.LAST_HOUR.name();
    private List<String> columns = Lists.newArrayList((Object[])new String[]{"All"});
    private String maxRows = "50";

    @Editable(name="Alert Source", order=100)
    @NotEmpty
    @ChoiceProvider(value="getAvailableSources")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Editable(name="Priority", order=200)
    @NotEmpty
    @ChoiceProvider(value="getAvailablePriorities")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    @Editable(name="Alert Definitions", order=300)
    @NotEmpty
    @ChoiceProvider(value="getAvailableDefinitions")
    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @Editable(name="Time Period", order=400)
    @NotEmpty
    @ChoiceProvider(value="getAvailableTimeSpan")
    public String getTimespan() {
        return this.timespan;
    }

    public void setTimespan(String timespan) {
        this.timespan = timespan;
    }

    @Editable(name="Display Columns", order=500)
    @NotEmpty
    @ChoiceProvider(value="getAvailableColumns")
    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    @Editable(name="Max Rows", order=600)
    @NotEmpty
    @Choices(value={"20", "50", "100", "200", "500"})
    public String getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(String maxRows) {
        this.maxRows = maxRows;
    }

    public Component renderBody(String componentId) {
        AlertTableBuilder builder = new AlertTableBuilder();
        if (!Objects.equal((Object)this.getSource(), (Object)"All")) {
            builder.setSource(this.getSource());
        }
        if (!Objects.equal((Object)this.getDefinition(), (Object)"All")) {
            builder.setDefinition(this.getDefinition());
        }
        if (!Objects.equal((Object)this.getPriority(), (Object)"All")) {
            builder.setPriority(Alert.AlertPriority.valueOf((String)this.getPriority()));
        }
        if (this.columns.contains("All")) {
            builder.setColumns(Lists.newArrayList((Object[])AlertTableBuilder.ColumnType.values()));
        } else {
            ArrayList types = Lists.newArrayList();
            for (String each : this.getColumns()) {
                types.add(AlertTableBuilder.ColumnType.fromDisplayName(each));
            }
            builder.setColumns(types);
        }
        builder.setTimespan(TimeSpan.valueOf(this.getTimespan()));
        builder.setMaxRows(Integer.valueOf(this.getMaxRows()));
        return new AlertGadgetPanel(componentId, builder);
    }

    private static List<String> getAvailableSources() {
        ArrayList nodes = Lists.newArrayList((Iterable)Grid.instance.getAllNodes());
        Collections.sort(nodes);
        ArrayList list = Lists.newArrayList();
        list.add("All");
        for (GridNode each : nodes) {
            list.add(each.getAddress());
        }
        return list;
    }

    private static List<String> getAvailableTimeSpan() {
        return ImmutableList.of((Object)TimeSpan.LAST_HOUR.name(), (Object)TimeSpan.LAST_2_HOURS.name(), (Object)TimeSpan.LAST_4_HOURS.name(), (Object)TimeSpan.LAST_DAY.name(), (Object)TimeSpan.LAST_WEEK.name(), (Object)TimeSpan.LAST_MONTH.name());
    }

    private static List<String> getAvailablePriorities() {
        ArrayList list = Lists.newArrayList();
        list.add("All");
        for (Alert.AlertPriority each : Alert.AlertPriority.values()) {
            list.add(each.name());
        }
        return list;
    }

    private static List<String> getAvailableDefinitions() {
        ArrayList list = Lists.newArrayList();
        AlertSetting setting = AlertSetting.get();
        list.add("All");
        for (AlertDefinition each : setting.getDefinitions()) {
            list.add(each.getName());
        }
        return list;
    }

    private static List<String> getAvailableColumns() {
        ArrayList list = Lists.newArrayList();
        list.add("All");
        for (AlertTableBuilder.ColumnType each : AlertTableBuilder.ColumnType.values()) {
            list.add(each.getDisplayName());
        }
        return list;
    }
}

