/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.alert.engine;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.extensionpoint.GadgetProvider;
import com.pmease.quickbuild.extensionpoint.RestResourceContribution;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.plugin.alert.engine.gadget.AlertGadget;
import com.pmease.quickbuild.plugin.alert.engine.rest.AlertRest;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertSetting;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertSettingPage;
import com.pmease.quickbuild.plugin.alert.engine.web.AlertPanel;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.page.administration.plugin.AbstractPluginSettingEditPage;
import com.pmease.quickbuild.web.page.grid.GridTabContribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.markup.html.panel.Panel;

public class AlertPlugin
extends AbstractPlugin {
    public static AlertPlugin get() {
        return (AlertPlugin)PluginManager.instance.getPlugin(AlertPlugin.class);
    }

    public Object[] getExtensions() {
        return new Object[]{new RestResourceContribution(){

            public Set<Class<?>> getResourceClasses() {
                return ImmutableSet.of(AlertRest.class);
            }
        }, new GridTabContribution(){

            public List<Tab> getTabs() {
                if (!SecurityHelper.isViewAlertsAllowed()) {
                    return Collections.emptyList();
                }
                ArrayList tabs = Lists.newArrayList();
                tabs.add(new Tab("alerts", "Alerts"){

                    public Panel getPanel(String id, Map<String, String> params) {
                        return new AlertPanel(id);
                    }

                    public int getOrder() {
                        return 9999;
                    }
                });
                return tabs;
            }
        }, new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return AlertGadget.class;
            }
        }};
    }

    public Class<?> getSettingClass() {
        return AlertSetting.class;
    }

    public AbstractPluginSettingEditPage getSettingEditPage() {
        return new AlertSettingPage();
    }

    public PluginCategory getCategory() {
        return PluginCategory.MEASUREMENT;
    }
}

