/*
 * Decompiled with CFR 0.152.
 */
package com.example.javancss;

import com.example.javancss.Metrics;
import com.example.javancss.MetricsStatistics;
import com.pmease.quickbuild.extensionpoint.StatisticsSupport;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.concurrent.locks.Lock;

public class JavaNCSSStatisticsSupport
implements StatisticsSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectStatistics(Build build) {
        File metricsFile = new File(build.getPublishDir(), "javancss_metrics.xml");
        if (metricsFile.exists()) {
            File statsFile = new File(build.getConfiguration().getPublishDir(), "javancss_statistics.xml");
            Lock lock = LockUtils.lockForWrite((File)statsFile);
            try {
                MetricsStatistics stats = statsFile.exists() ? (MetricsStatistics)BeanUtils.readFile((File)statsFile) : new MetricsStatistics();
                MetricsStatistics.Snapshot snapshot = new MetricsStatistics.Snapshot();
                snapshot.setBuildId(build.getId());
                snapshot.setBuildVersion(build.getVersion());
                snapshot.setMetrics((Metrics)BeanUtils.readFile((File)metricsFile));
                stats.getSnapshots().add(snapshot);
                BeanUtils.writeFile((Object)stats, (File)statsFile);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupStatistics(Configuration configuration) {
        File historyFile = new File(configuration.getPublishDir(), "javancss_statistics.xml");
        Lock lock = LockUtils.lockForWrite((File)historyFile);
        try {
            FileUtils.deleteFile((File)historyFile);
        }
        finally {
            lock.unlock();
        }
    }

    public String getStatisticsName() {
        return "Java NCSS";
    }
}

