/*
 * Decompiled with CFR 0.152.
 */
package com.example.javancss;

import com.example.javancss.Metrics;
import com.example.javancss.PluginSetting;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="JavaNCSS Report", category={"Publish"})
public class JavaNCSSPublishStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String reportPath;

    @Editable(order=1000, name="JavaNCSS Report Path", description="Specify path to JavaNCSS xml report file. A non-absolute path will be considered to be relative to current workspace directory. If left empty, the workspace directory itself will be assumed.")
    @Scriptable
    @NotEmpty
    public String getReportPath() {
        return this.reportPath;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Document dom;
        Context.getLogger().info("Publishing JavaNCSS metrics report...");
        File rawReportFile = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getReportPath());
        try {
            dom = new SAXReader().read(rawReportFile);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        int sourceLines = Integer.valueOf(dom.selectSingleNode("//javancss/packages/total/ncss").getText());
        int commentLines = Integer.valueOf(dom.selectSingleNode("//javancss/packages/total/single_comment_lines").getText()) + Integer.valueOf(dom.selectSingleNode("//javancss/packages/total/multi_comment_lines").getText()) + Integer.valueOf(dom.selectSingleNode("//javancss/packages/total/javadoc_lines").getText());
        int commentThreshold = ((PluginSetting)this.getPlugin().getSetting(true)).getCommentThreshold();
        if (100 * commentLines / (sourceLines + commentLines) < commentThreshold) {
            throw new QuickbuildException("Source comments are less than " + commentThreshold + "%.");
        }
        Metrics metrics = new Metrics();
        metrics.setCommentLines(commentLines);
        metrics.setSourceLines(sourceLines);
        File tempFile = FileUtils.createTempFile((String)"javancss");
        try {
            BeanUtils.writeFile((Object)metrics, (File)tempFile);
            Context.getBuild().publish(tempFile, "javancss_metrics.xml");
        }
        finally {
            FileUtils.deleteFile((File)tempFile);
        }
    }
}

