/*
 * Decompiled with CFR 0.152.
 */
package com.example.javancss;

import com.example.javancss.AggregationDbMigrator;
import com.example.javancss.JavaNCSSAggregation;
import com.example.javancss.JavaNCSSPublishStep;
import com.example.javancss.JavaNCSSStatisticsSupport;
import com.example.javancss.Metrics;
import com.example.javancss.MetricsStatistics;
import com.example.javancss.PluginSetting;
import com.example.javancss.web.AggregatedMetricsPanel;
import com.example.javancss.web.MetricsOverviewPanel;
import com.example.javancss.web.MetricsReportPanel;
import com.example.javancss.web.MetricsStatisticsPanel;
import com.example.javancss.web.MetricsSummaryPanel;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.extensionpoint.AggregationSupport;
import com.pmease.quickbuild.extensionpoint.BuildOverviewContribution;
import com.pmease.quickbuild.extensionpoint.BuildSummaryContribution;
import com.pmease.quickbuild.extensionpoint.BuildTabContribution;
import com.pmease.quickbuild.extensionpoint.ConfigurationOverviewContribution;
import com.pmease.quickbuild.extensionpoint.StatisticsTabContribution;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.util.datastore.FileDb;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.wicket.markup.html.panel.Panel;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class JavaNCSSPlugin
extends AbstractPlugin {
    public static final String METRICS_FILE = "javancss_metrics.xml";
    public static final String STATISTICS_FILE = "javancss_statistics.xml";
    public static final String AGGREGATION_DIR = "javancss_aggregations";

    public Object[] getExtensions() {
        return new Object[]{new StepProvider(){

            public Class<? extends Step> getStepClass() {
                return JavaNCSSPublishStep.class;
            }
        }, new AggregationSupport(){

            public Class<? extends Aggregation> getAggregationClass() {
                return JavaNCSSAggregation.class;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cleanupAggregations(Configuration configuration) {
                File aggregationDir = new File(configuration.getPublishDir(), JavaNCSSPlugin.AGGREGATION_DIR);
                Lock lock = LockUtils.lockForWrite((File)aggregationDir);
                try {
                    FileUtils.deleteDir((File)aggregationDir);
                }
                finally {
                    lock.unlock();
                }
            }
        }, new JavaNCSSStatisticsSupport(), new BuildOverviewContribution(){

            public int getOrder() {
                return 500;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<PanelCreator> getPanelCreators() {
                ArrayList<PanelCreator> creators = new ArrayList<PanelCreator>();
                File reportFile = new File(Context.getBuild().getPublishDir(), JavaNCSSPlugin.METRICS_FILE);
                Lock lock = LockUtils.lockForRead((File)reportFile);
                try {
                    if (reportFile.exists()) {
                        final Metrics report = (Metrics)BeanUtils.readFile((File)reportFile);
                        creators.add(new PanelCreator(){

                            public Panel newPanel(String id) {
                                return new MetricsOverviewPanel(id, report);
                            }
                        });
                    }
                }
                finally {
                    lock.unlock();
                }
                return creators;
            }
        }, new ConfigurationOverviewContribution(){

            public int getOrder() {
                return 500;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<PanelCreator> getPanelCreators() {
                ArrayList<PanelCreator> creators = new ArrayList<PanelCreator>();
                File aggregationDir = new File(Context.getConfiguration().getPublishDir(), JavaNCSSPlugin.AGGREGATION_DIR);
                Lock lock = LockUtils.lockForRead((File)aggregationDir);
                try {
                    if (aggregationDir.exists()) {
                        for (final File dbDir : aggregationDir.listFiles()) {
                            if (!(Context.getConfiguration().findAggregation(dbDir.getName()) instanceof JavaNCSSAggregation)) continue;
                            final Metrics metrics = (Metrics)new FileDb(dbDir, (FileDb.Migrator)new AggregationDbMigrator()).read(new FileDb.Callback(){

                                public Object execute(Connection conn) throws SQLException {
                                    Statement stmt = conn.createStatement();
                                    ResultSet rs = stmt.executeQuery("select sum(source_lines), sum(comment_lines) from metrics where day=0");
                                    Metrics metrics = new Metrics();
                                    if (rs.next()) {
                                        metrics.setSourceLines(rs.getInt(1));
                                        metrics.setCommentLines(rs.getInt(2));
                                    }
                                    return metrics;
                                }
                            });
                            creators.add(new PanelCreator(){

                                public Panel newPanel(String id) {
                                    return new AggregatedMetricsPanel(id, dbDir.getName(), metrics);
                                }
                            });
                        }
                    }
                    ArrayList<PanelCreator> arrayList = creators;
                    return arrayList;
                }
                finally {
                    lock.unlock();
                }
            }
        }, new BuildSummaryContribution(){

            public int getOrder() {
                return 1000;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<PanelCreator> getPanelCreators() {
                ArrayList<PanelCreator> creators = new ArrayList<PanelCreator>();
                File metricsFile = new File(Context.getBuild().getPublishDir(), JavaNCSSPlugin.METRICS_FILE);
                Lock lock = LockUtils.lockForRead((File)metricsFile);
                try {
                    if (metricsFile.exists()) {
                        final Metrics metrics = (Metrics)BeanUtils.readFile((File)metricsFile);
                        creators.add(new PanelCreator(){

                            public Panel newPanel(String id) {
                                return new MetricsSummaryPanel(id, Context.getBuild().getId(), metrics);
                            }
                        });
                    }
                }
                finally {
                    lock.unlock();
                }
                return creators;
            }
        }, new BuildTabContribution(){
            private static final long serialVersionUID = 1L;

            public int getOrder() {
                return 1000;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<Tab> getTabs() {
                ArrayList<Tab> tabs = new ArrayList<Tab>();
                File metricsFile = new File(Context.getBuild().getPublishDir(), JavaNCSSPlugin.METRICS_FILE);
                Lock lock = LockUtils.lockForRead((File)metricsFile);
                try {
                    if (metricsFile.exists()) {
                        final Metrics metrics = (Metrics)BeanUtils.readFile((File)metricsFile);
                        tabs.add(new Tab("JavaNCSS"){
                            private static final long serialVersionUID = 1L;

                            public Panel getPanel(String id, Map<String, String> params) {
                                return new MetricsReportPanel(id, metrics);
                            }
                        });
                    }
                }
                finally {
                    lock.unlock();
                }
                return tabs;
            }
        }, new StatisticsTabContribution(){
            private static final long serialVersionUID = 1L;

            public int getOrder() {
                return 1000;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<Tab> getTabs() {
                ArrayList<Tab> tabs = new ArrayList<Tab>();
                File statsFile = new File(Context.getConfiguration().getPublishDir(), JavaNCSSPlugin.STATISTICS_FILE);
                Lock lock = LockUtils.lockForRead((File)statsFile);
                try {
                    if (statsFile.exists()) {
                        final MetricsStatistics stats = (MetricsStatistics)BeanUtils.readFile((File)statsFile);
                        tabs.add(new Tab("JavaNCSS"){
                            private static final long serialVersionUID = 1L;

                            public Panel getPanel(String id, Map<String, String> params) {
                                DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                                for (MetricsStatistics.Snapshot snapshot : stats.getSnapshots()) {
                                    dataset.addValue((double)snapshot.getMetrics().getCommentLines(), (Comparable)((Object)"comment lines"), (Comparable)((Object)snapshot.getBuildVersion()));
                                    dataset.addValue((double)snapshot.getMetrics().getSourceLines(), (Comparable)((Object)"source lines"), (Comparable)((Object)snapshot.getBuildVersion()));
                                }
                                return new MetricsStatisticsPanel(id, (CategoryDataset)dataset, "Build");
                            }
                        });
                    }
                }
                finally {
                    lock.unlock();
                }
                File aggregationDir = new File(Context.getConfiguration().getPublishDir(), JavaNCSSPlugin.AGGREGATION_DIR);
                lock = LockUtils.lockForRead((File)aggregationDir);
                try {
                    if (aggregationDir.exists()) {
                        for (File dbDir : aggregationDir.listFiles()) {
                            if (!(Context.getConfiguration().findAggregation(dbDir.getName()) instanceof JavaNCSSAggregation)) continue;
                            final CategoryDataset dataset = (CategoryDataset)new FileDb(dbDir, (FileDb.Migrator)new AggregationDbMigrator()).read(new FileDb.Callback(){

                                public Object execute(Connection conn) throws SQLException {
                                    DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                                    Statement stmt = conn.createStatement();
                                    ResultSet rs = stmt.executeQuery("select * from metrics where day!=0 order by day desc");
                                    HashMap metricsByDay = new HashMap();
                                    HashSet<Integer> checkDays = new HashSet<Integer>();
                                    while (rs.next()) {
                                        int count = rs.getInt("count");
                                        int day = rs.getInt("day");
                                        int configuration = rs.getInt("configuration");
                                        int sourceLines = rs.getInt("source_lines");
                                        int commentLines = rs.getInt("comment_lines");
                                        checkDays.add(day);
                                        Iterator i$ = checkDays.iterator();
                                        while (i$.hasNext()) {
                                            int each = (Integer)i$.next();
                                            HashMap<Integer, PreciseMetrics> metricsByConfigurations = (HashMap<Integer, PreciseMetrics>)metricsByDay.get(each);
                                            if (metricsByConfigurations == null) {
                                                metricsByConfigurations = new HashMap<Integer, PreciseMetrics>();
                                                metricsByDay.put(each, metricsByConfigurations);
                                            }
                                            if (metricsByConfigurations.containsKey(configuration)) continue;
                                            PreciseMetrics metrics = new PreciseMetrics();
                                            metrics.setSourceLines((double)sourceLines * 1.0 / (double)count);
                                            metrics.setCommentLines((double)commentLines * 1.0 / (double)count);
                                            metricsByConfigurations.put(configuration, metrics);
                                        }
                                    }
                                    rs.close();
                                    ArrayList sortedDays = new ArrayList(checkDays);
                                    Collections.sort(sortedDays);
                                    Iterator i$ = sortedDays.iterator();
                                    while (i$.hasNext()) {
                                        int day = (Integer)i$.next();
                                        Map metricsByConfiguration = (Map)metricsByDay.get(day);
                                        double totalSourceLines = 0.0;
                                        double totalCommentLines = 0.0;
                                        for (PreciseMetrics metrics : metricsByConfiguration.values()) {
                                            totalSourceLines += metrics.getSourceLines();
                                            totalCommentLines += metrics.getCommentLines();
                                        }
                                        Date date = new Date((long)(day * 24 * 3600) * 1000L);
                                        String displayDate = DateUtils.formatDate((Date)date);
                                        dataset.addValue((double)((int)totalCommentLines), (Comparable)((Object)"comment lines"), (Comparable)((Object)displayDate));
                                        dataset.addValue((double)((int)totalSourceLines), (Comparable)((Object)"source lines"), (Comparable)((Object)displayDate));
                                    }
                                    return dataset;
                                }
                            });
                            tabs.add(new Tab(dbDir.getName()){
                                private static final long serialVersionUID = 1L;

                                public Panel getPanel(String id, Map<String, String> params) {
                                    return new MetricsStatisticsPanel(id, dataset, "Date");
                                }
                            });
                        }
                    }
                    ArrayList<Tab> arrayList = tabs;
                    return arrayList;
                }
                finally {
                    lock.unlock();
                }
            }
        }};
    }

    public Class<?> getSettingClass() {
        return PluginSetting.class;
    }

    private static class PreciseMetrics {
        private double sourceLines;
        private double commentLines;

        private PreciseMetrics() {
        }

        public double getSourceLines() {
            return this.sourceLines;
        }

        public void setSourceLines(double sourceLines) {
            this.sourceLines = sourceLines;
        }

        public double getCommentLines() {
            return this.commentLines;
        }

        public void setCommentLines(double commentLines) {
            this.commentLines = commentLines;
        }
    }
}

