/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.checkstyle.renderer;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.checkstyle.CheckStyleBlock;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ViewSourceLinkItem;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.util.LinkedHashMap;
import java.util.List;

public class CheckStyleViewSourceItem
extends ViewSourceLinkItem {
    private static final long serialVersionUID = 1L;

    public CheckStyleViewSourceItem(AbstractRenderer renderer) {
        super(renderer);
    }

    private String lineMessage(String severity, int col, String message) {
        StringBuffer sb = new StringBuffer();
        sb.append("<li>").append(severity).append(" (col: ").append(col).append(") ").append(message).append("</li>");
        return sb.toString();
    }

    protected Block[] rowsToBlocks(List<DataRow> rows) {
        LinkedHashMap blocks = Maps.newLinkedHashMap();
        for (DataRow each : rows) {
            CheckStyleBlock block;
            int line = each.getInt("line");
            if (line == 0) {
                line = 1;
            }
            if ((block = (CheckStyleBlock)((Object)blocks.get(line))) == null) {
                block = new CheckStyleBlock();
                blocks.put(line, block);
                block.setStartLine(line);
                block.setEndLine(line);
                block.setMessage("");
            }
            StringBuffer sb = new StringBuffer();
            String message = each.getValueAsString("message");
            int column = each.getInt("column");
            String severity = each.getValueAsString("severity");
            sb.append(this.lineMessage(severity, column, message));
            block.setViolations(block.getViolations() + 1);
            if (Strings.isNullOrEmpty((String)block.getMessage())) {
                block.setMessage(sb.toString());
            } else {
                block.setMessage(block.getMessage() + sb.toString());
            }
            block.setColor("#FF1A00");
        }
        return (Block[])Iterables.toArray(blocks.values(), Block.class);
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new SourceViewPage(title, sourceType, lines, blocks, startLine){
            private static final long serialVersionUID = 1L;

            protected String renderContent(String[] lines, Block[] blocks) {
                StringBuffer sb = new StringBuffer();
                int i = 1;
                sb.append("<table>");
                if (blocks.length > 0) {
                    for (Block each : blocks) {
                        CheckStyleBlock line = (CheckStyleBlock)each;
                        while (i < each.getStartLine() && i <= lines.length) {
                            sb.append("<tr>");
                            sb.append("<td class='committers'></td>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits'></td>");
                            sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                        String color = each.getColor();
                        String message = "<ul class='square'>" + each.getMessage() + "</ul>";
                        message = 1.escapeMessage((String)message);
                        while (i <= each.getEndLine()) {
                            sb.append("<tr>");
                            if (!Strings.isNullOrEmpty((String)line.getCommitters())) {
                                sb.append("<td class='committers'>").append(line.getCommitters()).append("</td>");
                            } else {
                                sb.append("<td class='committers'></td>");
                            }
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits' style='background-color: ").append(color).append("'>").append("<div class='with-msg' ").append("title=\"").append(message).append("\">").append(line.getViolations()).append("</div>").append("</td>");
                            sb.append("<td class='line-content' style='border-color: " + color + "'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                    }
                }
                while (i <= lines.length) {
                    sb.append("<tr>");
                    sb.append("<td class='committers'></td>");
                    sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                    if (blocks.length > 0) {
                        sb.append("<td class='hits'></td>");
                    }
                    sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                    sb.append("</tr>");
                    ++i;
                }
                sb.append("</table>");
                return sb.toString();
            }
        };
    }

    static enum DiffStatus {
        ADDED,
        FIXED,
        NOT_FIXED;

    }
}

