/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.checkstyle;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.checkstyle.CheckStylePlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;

@Editable(category={"Publish"}, name="CheckStyle Report", description="<strong>Notice</strong><br/>Make sure this step is running on the same node as the node where you run checkstyle (normally, this will be the node your builder running.)")
@ScriptApi(value="This step publishes the original CheckStyle XML files.")
public class CheckStylePublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int violations;
    @XStreamOmitField
    private int highs;
    @XStreamOmitField
    private int mediums;
    @XStreamOmitField
    private int normals;
    @XStreamOmitField
    private int lows;

    public CheckStylePublisher() {
        this.setStepFailureCondition("false");
        this.setStepFailureMessage("");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(CheckStylePlugin.class);
    }

    protected String getStatsReportName() {
        return "stats";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        File dbDir = context.getWorkingDir();
        if (!dbDir.exists()) {
            return;
        }
        Map map = category.getDefaultStats(dbDir, "files", new Filter[0]);
        DataReport statsReport = category.createReport("stats");
        DataRow row = statsReport.addRow();
        row.setValue("buildId", (Object)context.getCurrentBuild().getId());
        row.fromMap(map);
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "CheckStylePublisher::saveStatsReport");
            Long l = db.queryForLong("SELECT COUNT(*) from files where violations != fixed");
            row.setValue("files", (Object)l);
            this.violations = row.getInt("violations");
            this.highs = row.getInt("highs");
            this.mediums = row.getInt("mediums");
            this.normals = row.getInt("normals");
            this.lows = row.getInt("lows");
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byFileUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"violated_files", (String)reportsetName)).put((Object)"violationsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_violations", (String)reportsetName)).build();
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @ScriptApi(value="Total violations in CheckStyle report.")
    public int getViolations() {
        return this.violations;
    }

    public void setViolations(int violations) {
        this.violations = violations;
    }

    @ScriptApi(value="Total high priority violations in CheckStyle report.")
    public int getHighs() {
        return this.highs;
    }

    public void setHighs(int highs) {
        this.highs = highs;
    }

    @ScriptApi(value="Total medium priority violations in CheckStyle report.")
    public int getMediums() {
        return this.mediums;
    }

    public void setMediums(int mediums) {
        this.mediums = mediums;
    }

    @ScriptApi(value="Total normal priority violations in CheckStyle report.")
    public int getNormals() {
        return this.normals;
    }

    public void setNormals(int normals) {
        this.normals = normals;
    }

    @ScriptApi(value="Total low priority violations in CheckStyle report.")
    public int getLows() {
        return this.lows;
    }

    public void setLows(int lows) {
        this.lows = lows;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.setValue("stepFailureCondition", "false");
        dom.setValue("stepFailureMessage", "");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        CheckStylePublisher.removeElement((VersionedDocument)dom, (String)"violations");
        CheckStylePublisher.removeElement((VersionedDocument)dom, (String)"highs");
        CheckStylePublisher.removeElement((VersionedDocument)dom, (String)"mediums");
        CheckStylePublisher.removeElement((VersionedDocument)dom, (String)"normals");
        CheckStylePublisher.removeElement((VersionedDocument)dom, (String)"lows");
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return CheckstyleChecksum.class;
    }

    public static class CheckstyleChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(CheckStylePlugin.class);
        }
    }
}

