/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.checkstyle;

import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.extensionpoint.AggregationSupport;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.checkstyle.CheckStyleCategory;
import com.pmease.quickbuild.plugin.report.checkstyle.CheckStylePublisher;
import com.pmease.quickbuild.plugin.report.checkstyle.aggregation.CheckStyleAggregator;
import com.pmease.quickbuild.plugin.report.checkstyle.gadget.CheckStyleAggregatedOverviewGadget;
import com.pmease.quickbuild.plugin.report.checkstyle.gadget.CheckStyleAggregatedStatsGadget;
import com.pmease.quickbuild.plugin.report.checkstyle.gadget.CheckStyleOverviewGadget;
import com.pmease.quickbuild.plugin.report.checkstyle.gadget.CheckStyleStatsGadget;
import com.pmease.quickbuild.plugin.report.checkstyle.gadget.TopViolatedGadget;
import com.pmease.quickbuild.plugin.report.checkstyle.rest.CheckStyleRest;
import com.pmease.quickbuild.plugin.report.engine.contribution.AbstractReportPlugin;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryAggregationOverview;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryAggregationStatsTab;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;

public class CheckStylePlugin
extends AbstractReportPlugin {
    static final String CHECKSTYLE_AGGREGATION_STATS_TAB = "CheckStyle Aggregated";

    protected Class<? extends Step> getPublishStepClass() {
        return CheckStylePublisher.class;
    }

    protected ReportCategory createCategory() {
        return new CheckStyleCategory();
    }

    protected Class<?>[] getRestResourceClasses() {
        return new Class[]{CheckStyleRest.class};
    }

    protected Class<? extends Gadget>[] getGadgetClasses() {
        return new Class[]{CheckStyleOverviewGadget.class, TopViolatedGadget.class, CheckStyleStatsGadget.class, CheckStyleAggregatedOverviewGadget.class, CheckStyleAggregatedStatsGadget.class};
    }

    protected Object[] getAggregationSupport() {
        return new Object[]{new AggregationSupport(){

            public Class<? extends Aggregation> getAggregationClass() {
                return CheckStyleAggregator.class;
            }

            public void cleanupAggregations(Configuration configuration) {
                ReportCategory category = CheckStylePlugin.this.getReportCategory();
                category.deleteAllReportSetsOfAggregation(configuration);
            }
        }, new CategoryAggregationOverview(){

            protected ReportCategory getCategory() {
                return CheckStylePlugin.this.getReportCategory();
            }

            protected String getToTab() {
                return Tab.title2id((String)CheckStylePlugin.CHECKSTYLE_AGGREGATION_STATS_TAB);
            }
        }, new CategoryAggregationStatsTab(){
            private static final long serialVersionUID = 1L;

            public String getTitle() {
                return CheckStylePlugin.CHECKSTYLE_AGGREGATION_STATS_TAB;
            }

            public ReportCategory getCategory() {
                return CheckStylePlugin.this.getReportCategory();
            }

            protected boolean isAggregationApplicable(Aggregation aggregation) {
                return aggregation.getClass().isAssignableFrom(CheckStyleAggregator.class);
            }
        }};
    }
}

