/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.findbugs.renderer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ViewSourceLinkItem;
import com.pmease.quickbuild.plugin.report.findbugs.renderer.BugBlock;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.util.ArrayList;
import java.util.List;

public class ViewBugSourceItem
extends ViewSourceLinkItem {
    private static final long serialVersionUID = 1L;

    public ViewBugSourceItem(AbstractRenderer renderer) {
        super(renderer);
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new SourceViewPage(title, sourceType, lines, blocks, startLine){
            private static final long serialVersionUID = 1L;

            protected String renderContent(String[] lines, Block[] blocks) {
                StringBuffer sb = new StringBuffer();
                int i = 1;
                sb.append("<table>");
                if (blocks.length > 0) {
                    for (Block each : blocks) {
                        while (i < each.getStartLine() && i <= lines.length) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits'></td>");
                            sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                        BugBlock block = (BugBlock)each;
                        String color = each.getColor();
                        String message = 1.escapeMessage((String)each.getMessage());
                        while (i <= each.getEndLine() && i <= lines.length) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits' style='background-color: ").append(color).append("'>").append("<div class='with-msg' ").append("title=\"").append(message).append("\">");
                            if (i == each.getStartLine()) {
                                sb.append(block.getAbbrev());
                            } else {
                                sb.append("&nbsp;&nbsp;&nbsp;");
                            }
                            sb.append("</div>").append("</td>");
                            sb.append("<td class='line-content' style='border-color: ").append(color).append("'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                    }
                }
                while (i <= lines.length) {
                    sb.append("<tr>");
                    sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                    if (blocks.length > 0) {
                        sb.append("<td class='hits'></td>");
                    }
                    sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                    sb.append("</tr>");
                    ++i;
                }
                sb.append("</table>");
                return sb.toString();
            }
        };
    }

    protected Block[] rowsToBlocks(List<DataRow> rows) {
        ArrayList blocks = Lists.newArrayList();
        for (DataRow each : rows) {
            List list = (List)each.getValue("sourceLines");
            for (Block b : list) {
                BugBlock block = new BugBlock();
                int line = b.getStartLine();
                if (line <= 0) {
                    line = 1;
                }
                block.setStartLine(line);
                line = b.getEndLine();
                if (line <= 0) {
                    line = 1;
                }
                block.setEndLine(line);
                boolean fixed = "FIXED".equalsIgnoreCase(each.getValueAsString("diffStatus"));
                block.setFixed(fixed);
                String message = each.getValueAsString("longMessage");
                if (fixed) {
                    message = "Fixed: " + message;
                }
                block.setMessage(message);
                String priority = each.getValueAsString("priority");
                block.setPriority(priority);
                if (fixed) {
                    block.setColor("#008C00");
                    block.setAbbrev("FIX");
                } else {
                    block.setColor(ViewBugSourceItem.getBlockColor(priority));
                    block.setAbbrev(priority == null ? "" : priority.substring(0, 3));
                }
                blocks.add(block);
            }
        }
        return (Block[])Iterables.toArray((Iterable)blocks, Block.class);
    }

    static String getBlockColor(String priority) {
        if ("HIGH".equals(priority)) {
            return "#FF1A00";
        }
        if ("MEDIUM".equals(priority)) {
            return "#FF7400";
        }
        if ("NORMAL".equals(priority)) {
            return "#3274D0";
        }
        return "#008C00";
    }
}

