/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.findbugs.renderer;

import com.google.common.base.Joiner;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.findbugs.renderer.BugColumn;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BugColumnPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public BugColumnPanel(String id, BugColumn column, IModel<ItemContext> model) {
        super(id, model);
        this.add(new Component[]{column.classLinkItem.createComponent("classLink", model)});
        this.add(new Component[]{column.packageLinkItem.createComponent("packageLink", model)});
        this.add(new Component[]{column.categoryLinkItem.createComponent("categoryLink", model)});
        this.add(new Component[]{column.codeLinkItem.createComponent("codeLink", model)});
        this.add(new Component[]{column.typeLinkItem.createComponent("typeLink", model)});
        this.add(new Component[]{column.bugcodeDropDownItem.createComponent("bugcodeDropDown", model)});
        this.add(new Component[]{column.viewSourceItem.createComponent("viewSourceLink", model)});
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        Label priorityLabel = new Label("priority", ReportUtils.firstOf((String)row.getValueAsString("priority"), (int)3));
        priorityLabel.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)row.getValueAsString("priority").toLowerCase())), " ")});
        this.add(new Component[]{priorityLabel});
        this.add(new Component[]{new Label("shortMessage", row.getValueAsString("shortMessage"))});
        this.add(new Component[]{new Label("longMessage", row.getValueAsString("longMessage"))});
        List detailMessages = (List)row.getValue("detailMessages");
        StringBuffer sb = new StringBuffer();
        for (String each : detailMessages) {
            sb.append(StringEscapeUtils.escapeHtml((String)each)).append("<br/>");
        }
        this.add(new Component[]{new Label("detailMessages", sb.toString()).setEscapeModelStrings(false)});
        List committers = (List)row.getValue("committers");
        if (committers == null || committers.isEmpty()) {
            this.add(new Component[]{new WebMarkupContainer("committers").setVisible(false)});
        } else {
            this.add(new Component[]{new Label("committers", Joiner.on((String)", ").skipNulls().join((Iterable)committers))});
        }
        this.add(new Component[]{new Label("diffStatus", row.getValueAsString("diffStatus"))});
    }
}

