/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.findbugs.generator;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.AlwaysNewValue;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.report.findbugs.generator.BugDiffProcessor;
import com.pmease.quickbuild.plugin.report.findbugs.generator.GroupByClassProcessor;
import com.pmease.quickbuild.plugin.report.findbugs.generator.GroupByFileProcessor;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.page.source.Block;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class BugProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;

    public BugProcessor(ReportCategory category) {
        super(category);
    }

    protected void processResource(GeneratorResource resource) {
        File inputFile = resource.getFile();
        if (!inputFile.exists()) {
            return;
        }
        Document doc = XMLHelper.readXML((File)inputFile);
        Element root = doc.getRootElement();
        ArrayList srcDirs = Lists.newArrayList();
        List nodes = root.selectNodes("/BugCollection/Project/SrcDir");
        for (Element each : nodes) {
            srcDirs.add(each.getTextTrim());
        }
        GeneratorContext context = GeneratorContext.getContext();
        String projectName = root.valueOf("./Project/@projectName");
        if (Objects.equal((Object)context.getReportSet(), (Object)"DEFAULT") && !Strings.isNullOrEmpty((String)projectName) && !Objects.equal((Object)projectName, (Object)context.getReportSet())) {
            context.setReportSet(projectName);
            File oldWorkingDir = context.getWorkingDir();
            File newWorkingDir = new File(oldWorkingDir.getParentFile(), projectName);
            try {
                FileUtils.moveDirectory((File)oldWorkingDir, (File)newWorkingDir);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            context.setWorkingDir(newWorkingDir);
        }
        File dbDir = context.getWorkingDir();
        this.generateBugDescriptions(root, dbDir);
        this.generateBugCollection(root, srcDirs);
    }

    private DataReport generateBugCollection(Element root, List<String> srcDirs) {
        this.getLogger().info("generating bugcategory report ...");
        DataReport report = this.getContext().getDestReport();
        List nodes = root.elements("BugInstance");
        String workspacePath = GeneratorContext.getContext().getWorkspaceDir();
        for (Element each : nodes) {
            DataRow row = report.addRow();
            row.setValue("instanceHash", (Object)each.valueOf("./@instanceHash"));
            row.setValue("instanceOccurrenceNumber", DataTypes.INTEGER.fromString(each.valueOf("./@instanceOccurrenceNum"), null));
            row.setValue("categoryName", (Object)each.valueOf("./@category"));
            row.setValue("patternType", (Object)each.valueOf("./@type"));
            row.setValue("abbrev", (Object)each.valueOf("./@abbrev"));
            row.setValue("shortMessage", (Object)each.valueOf("./ShortMessage"));
            row.setValue("longMessage", (Object)each.valueOf("./LongMessage"));
            Integer p = (Integer)DataTypes.INTEGER.fromString(each.valueOf("./@priority"));
            if (p == null) {
                p = 4;
            }
            if (p == 1) {
                row.setValue("priority", (Object)"HIGH");
            } else if (p == 2) {
                row.setValue("priority", (Object)"MEDIUM");
            } else if (p == 3) {
                row.setValue("priority", (Object)"NORMAL");
            } else {
                row.setValue("priority", (Object)"EXP");
            }
            String className = each.valueOf("./Class[1]/@classname");
            String packageName = ReportUtils.getPackageNameFromClassName((String)className);
            className = ReportUtils.getClassNameFromClassName((String)className);
            row.setValue("packageName", (Object)packageName);
            row.setValue("className", (Object)className);
            String sourcePath = each.valueOf("./SourceLine[1]/@sourcepath");
            sourcePath = ReportUtils.getRelativePath(srcDirs, (String)sourcePath, (String)workspacePath);
            row.setValue("fileName", (Object)sourcePath);
            ArrayList messages = Lists.newArrayList();
            List elements = each.selectNodes(".//Message");
            for (Element e : elements) {
                messages.add(e.getText());
            }
            row.setValue("detailMessages", (Object)messages);
            ArrayList blocks = Lists.newArrayList();
            elements = each.selectNodes("./SourceLine");
            for (Element e : elements) {
                Block block = new Block();
                int startLine = XMLHelper.getInt((Node)e, (String)"start", (Integer)0);
                int endLine = XMLHelper.getInt((Node)e, (String)"end", (Integer)0);
                block.setStartLine(startLine);
                block.setEndLine(endLine);
                blocks.add(block);
            }
            row.setValue("sourceLines", (Object)blocks);
        }
        return report;
    }

    DataReport diffPrevious(DataReport bugReport) {
        GeneratorContext context = this.getContext();
        context.setDestReport(bugReport);
        BugDiffProcessor diffProcessor = new BugDiffProcessor(this.getCategory());
        diffProcessor.execute();
        DataReport destReport = context.getDestReport();
        context.setDestReport(null);
        return destReport;
    }

    void generateFileStats(Element root, List<String> srcDirs, File dbDir, DataReport bugReport) {
        ReportCategory category = this.getCategory();
        DataReport destReport = category.createReport("filestats");
        List nodes = root.selectNodes(".//FileStats");
        String workspacePath = this.getContext().getWorkspaceDir();
        for (Element each : nodes) {
            String path = each.valueOf("./@path");
            path = ReportUtils.getRelativePath(srcDirs, (String)path, (String)workspacePath);
            DataRow row = destReport.addRow();
            row.setValue("fileName", (Object)path);
            row.setValue("codeSize", (Object)each.valueOf("./@size"));
        }
        GeneratorResource resource = new GeneratorResource();
        resource.setPassthroughObject((Object)bugReport);
        this.getContext().setDestReport(destReport);
        this.getContext().setResources(new GeneratorResource[]{resource});
        GroupByFileProcessor processor = new GroupByFileProcessor(category);
        processor.execute();
        category.saveReport(dbDir, this.getContext().getDestReport(), (MergeFunction)new AlwaysNewValue());
    }

    void generateClassStats(Element root, File dbDir, DataReport bugReport) {
        ReportCategory category = this.getCategory();
        DataReport destReport = category.createReport("classstats");
        List nodes = root.selectNodes(".//ClassStats");
        for (Element each : nodes) {
            DataRow row = destReport.addRow();
            String className = each.valueOf("./@class");
            String packageName = ReportUtils.getPackageNameFromClassName((String)className);
            className = ReportUtils.getClassNameFromClassName((String)className);
            row.setValue("packageName", (Object)packageName);
            row.setValue("className", (Object)className);
            row.setValue("codeSize", (Object)XMLHelper.getInt((Node)each, (String)"./@size", (Integer)0));
            row.setValue("violations", (Object)XMLHelper.getInt((Node)each, (String)"./@bugs", (Integer)0));
        }
        GeneratorResource resource = new GeneratorResource();
        resource.setPassthroughObject((Object)bugReport);
        this.getContext().setDestReport(destReport);
        this.getContext().setResources(new GeneratorResource[]{resource});
        GroupByClassProcessor processor = new GroupByClassProcessor(category);
        processor.execute();
        destReport = this.getContext().getDestReport();
        category.saveReport(dbDir, destReport);
        this.getContext().setDestReport(null);
    }

    private void generateBugDescriptions(Element root, File dbDir) {
        DataReport categoryReport = this.generateBugCategory(root);
        DataReport patternReport = this.generateBugPatternReport(root);
        DataReport bugcodeReport = this.generateBugCodeReport(root);
        AlwaysNewValue alwaysNew = new AlwaysNewValue();
        ReportCategory category = this.getCategory();
        category.saveReport(dbDir, categoryReport, (MergeFunction)alwaysNew);
        category.saveReport(dbDir, patternReport, (MergeFunction)alwaysNew);
        category.saveReport(dbDir, bugcodeReport, (MergeFunction)alwaysNew);
    }

    private DataReport generateBugCategory(Element root) {
        this.getLogger().info("generating bugcategory report ...");
        ReportCategory category = this.getCategory();
        DataReport categoryReport = category.createReport("bugcategory");
        List nodes = root.selectNodes("/BugCollection/BugCategory");
        for (Element each : nodes) {
            DataRow row = categoryReport.addRow();
            row.setValue("categoryName", (Object)each.valueOf("./@category"));
            row.setValue("description", (Object)each.valueOf("./Description"));
            String str = each.valueOf("./Abbreviation");
            if (Strings.isNullOrEmpty((String)str)) {
                str = row.getValueAsString("categoryName");
            }
            row.setValue("categoryAbbrev", (Object)str);
            row.setValue("details", (Object)each.valueOf("./Details"));
        }
        return categoryReport;
    }

    private DataReport generateBugPatternReport(Element root) {
        this.getLogger().info("generating bugpattern report ...");
        ReportCategory category = this.getCategory();
        DataReport patternReport = category.createReport("bugpattern");
        List nodes = root.selectNodes("/BugCollection/BugPattern");
        for (Element each : nodes) {
            DataRow row = patternReport.addRow();
            row.setValue("patternType", (Object)each.valueOf("./@type"));
            row.setValue("abbrev", (Object)each.valueOf("./@abbrev"));
            row.setValue("categoryName", (Object)each.valueOf("./@category"));
            row.setValue("shortDescription", (Object)each.valueOf("./ShortDescription"));
            row.setValue("details", (Object)each.valueOf("./Details"));
        }
        return patternReport;
    }

    private DataReport generateBugCodeReport(Element root) {
        this.getLogger().info("generating bugcode report ...");
        ReportCategory category = this.getCategory();
        DataReport bugcodeReport = category.createReport("bugcode");
        List nodes = root.selectNodes("/BugCollection/BugCode");
        for (Element each : nodes) {
            DataRow row = bugcodeReport.addRow();
            row.setValue("abbrev", (Object)each.valueOf("./@abbrev"));
            row.setValue("description", (Object)each.valueOf("./Description"));
        }
        return bugcodeReport;
    }
}

