/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.findbugs.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.findbugs.FindbugsPlugin;

@Editable(name="FindBugs Report")
public class FindBugsAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(FindbugsPlugin.class);
    }

    static double getDensity(DataRow destRow) {
        int codeSize = destRow.getInt("codeSize");
        int violations = destRow.getInt("violations");
        return MathUtils.divide((int)violations, (int)(codeSize * 1000));
    }

    static void updateDensity(DataRow row) {
        row.setValue("density", (Object)FindBugsAggregator.getDensity(row));
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        super.aggregateOverview(sourceRow, destRow);
        FindBugsAggregator.updateDensity(destRow);
    }

    protected void updateStatsRow(DataRow row) {
        super.updateStatsRow(row);
        FindBugsAggregator.updateDensity(row);
    }

    protected String[] getAggregateColumns() {
        return new String[]{"packages", "classes", "codeSize", "violations", "fixed", "notFixed", "added", "highs", "mediums", "normals", "lows"};
    }
}

