/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.findbugs;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.findbugs.FindbugsPlugin;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="Findbugs Report", description="<strong>Notice</strong><br/> Make sure this step is running on the same node as the node where you run findbugs (normally, this will be the node your builder running.)")
@ScriptApi(value="This step publishes the original FindBugs XML files.")
public class FindbugsPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int violations;
    @XStreamOmitField
    private int highs;
    @XStreamOmitField
    private int mediums;
    @XStreamOmitField
    private int normals;
    @XStreamOmitField
    private int lows;
    @XStreamOmitField
    private int codeSize;
    @XStreamOmitField
    private float density;

    public FindbugsPublisher() {
        this.setStepFailureCondition("false");
        this.setStepFailureMessage("");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(FindbugsPlugin.class);
    }

    protected String getStatsReportName() {
        return "stats";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        File dbDir = context.getWorkingDir();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "FindbugsPublisher::saveStatsReport");
            Map stats = category.getDefaultStats(db, "packagestats", new Filter[0]);
            DataRow row = statsReport.addRow();
            row.fromMap(stats);
            row.setValue("buildId", (Object)context.getCurrentBuild().getId());
            this.violations = row.getInt("violations");
            this.highs = row.getInt("highs");
            this.mediums = row.getInt("mediums");
            this.normals = row.getInt("normals");
            this.lows = row.getInt("lows");
            this.codeSize = row.getInt("codeSize");
            this.density = this.codeSize == 0 ? 0.0f : new Float(this.violations).floatValue() / (float)this.codeSize * 1000.0f;
            row.setValue("density", (Object)Float.valueOf(this.density));
            db.update("DELETE FROM stats WHERE buildId=" + context.getCurrentBuild().getId());
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byWarningUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_warning", (String)reportsetName)).build();
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"I don't care", "false", "Current density is too high", "current.density > 5.0"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    @ScriptApi(value="Total violations in FindBugs report.")
    public int getViolations() {
        return this.violations;
    }

    public void setViolations(int violations) {
        this.violations = violations;
    }

    @ScriptApi(value="Total high priority violations in FindBugs report.")
    public int getHighs() {
        return this.highs;
    }

    public void setHighs(int highs) {
        this.highs = highs;
    }

    @ScriptApi(value="Total medium priority violations in FindBugs report.")
    public int getMediums() {
        return this.mediums;
    }

    public void setMediums(int mediums) {
        this.mediums = mediums;
    }

    @ScriptApi(value="Total normal priority violations in FindBugs report.")
    public int getNormals() {
        return this.normals;
    }

    public void setNormals(int normals) {
        this.normals = normals;
    }

    @ScriptApi(value="Total low priority violations in FindBugs report.")
    public int getLows() {
        return this.lows;
    }

    public void setLows(int lows) {
        this.lows = lows;
    }

    @ScriptApi(value="Total code size in FindBugs report.")
    public int getCodeSize() {
        return this.codeSize;
    }

    public void setCodeSize(int codeSize) {
        this.codeSize = codeSize;
    }

    @ScriptApi(value="Average density (codeSize / violations * 1000) in FindBugs report.")
    public float getDensity() {
        return this.density;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.setValue("stepFailureCondition", "false");
        dom.setValue("stepFailureMessage", "");
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return FindbugsChecksum.class;
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        FindbugsPublisher.removeElement((VersionedDocument)dom, (String)"violations");
        FindbugsPublisher.removeElement((VersionedDocument)dom, (String)"highs");
        FindbugsPublisher.removeElement((VersionedDocument)dom, (String)"mediums");
        FindbugsPublisher.removeElement((VersionedDocument)dom, (String)"normals");
        FindbugsPublisher.removeElement((VersionedDocument)dom, (String)"lows");
        FindbugsPublisher.removeElement((VersionedDocument)dom, (String)"codeSize");
        FindbugsPublisher.removeElement((VersionedDocument)dom, (String)"density");
    }

    public static class FindbugsChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(FindbugsPlugin.class);
        }
    }
}

