/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.statstab;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.StatisticsTabContribution;
import com.pmease.quickbuild.plugin.report.customstats.PluginSetting;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryStatisticsTab;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CustomStatsStatisticsContribution
implements StatisticsTabContribution {
    private static final long serialVersionUID = 1L;

    public int getOrder() {
        return 999;
    }

    public List<Tab> getTabs() {
        List<ReportCategory> categories = PluginSetting.getCategories();
        if (categories.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList tabs = Lists.newArrayList();
        for (ReportCategory each : categories) {
            File statsDir;
            if (!SecurityHelper.hasPermission((String)each.getName().toUpperCase()) || !(statsDir = each.getCategoryDirOfStats(Context.getConfiguration())).exists()) continue;
            CustomStatisticsTab tab = new CustomStatisticsTab(each);
            tabs.addAll(tab.getTabs());
        }
        return tabs;
    }

    private class CustomStatisticsTab
    extends CategoryStatisticsTab {
        private static final long serialVersionUID = 1L;
        private final ReportCategory category;

        public CustomStatisticsTab(ReportCategory category) {
            this.category = category;
        }

        public ReportCategory getCategory() {
            return this.category;
        }
    }
}

