/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.setting;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsCategory;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsPlugin;
import com.pmease.quickbuild.plugin.report.customstats.PluginSetting;
import com.pmease.quickbuild.plugin.report.customstats.setting.AbstractTableColumn;
import com.pmease.quickbuild.plugin.report.customstats.setting.CategoryEditor;
import com.pmease.quickbuild.plugin.report.customstats.setting.TablePropertyColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ListDataProvider;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.page.administration.plugin.AbstractPluginSettingEditPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.HeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class CustomStatsSettingPage
extends AbstractPluginSettingEditPage {
    private static final long serialVersionUID = 1L;

    public CustomStatsSettingPage() {
        this.add(new Component[]{new ViewFragment()});
    }

    public void setViewMode() {
        this.addOrReplace(new Component[]{new ViewFragment()});
    }

    public void setEditorMode(final Mode mode, String title, CustomStatsCategory category) {
        this.addOrReplace(new Component[]{new CategoryEditor("panel", mode, title, category, this).add(new Behavior[]{new AttributeAppender("class", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return mode != Mode.VIEW ? "editor-mode" : "";
            }
        }, " ")})});
    }

    class RowFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public RowFragment(String id, final IModel<CustomStatsCategory> model) {
            super(id, "operationFragment", (MarkupContainer)CustomStatsSettingPage.this);
            final CustomStatsCategory category = (CustomStatsCategory)model.getObject();
            this.add(new Component[]{new Link<Void>("edit"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    CustomStatsSettingPage.this.setEditorMode(Mode.EDIT, "Edit category - " + category.getCategoryName(), (CustomStatsCategory)model.getObject());
                }
            }});
            this.add(new Component[]{new Link<Void>("copy"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    CustomStatsCategory category = (CustomStatsCategory)model.getObject();
                    CustomStatsCategory newCategory = (CustomStatsCategory)BeanUtils.clone((Object)category);
                    newCategory.setCategoryId("new" + newCategory.getCategoryId());
                    newCategory.setCategoryName("New " + category.getCategoryName());
                    CustomStatsSettingPage.this.setEditorMode(Mode.COPY, "Copy category from: " + category.getCategoryName(), newCategory);
                }
            }});
            Link<Void> link = new Link<Void>("delete"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    PluginSetting s = (PluginSetting)PluginSettingHelper.getSetting(CustomStatsPlugin.class, (boolean)false);
                    if (s != null) {
                        String previousAuditContent = VersionedDocument.fromBean((Object)s).toXML();
                        s.removeCategory(category);
                        PluginSettingHelper.saveSetting(CustomStatsPlugin.class, (Object)s);
                        AuditManager.instance.audit("Administration::Plugin", "Custom stats setting was modified.", VersionedDocument.fromBean((Object)s).toXML(), previousAuditContent);
                        CustomStatsSettingPage.this.setViewMode();
                    }
                }
            };
            this.add(new Component[]{link});
            link.add(new Behavior[]{new ConfirmBehavior("Are you sure want to remove the category: " + category.getCategoryName() + "?")});
        }
    }

    class ViewFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public ViewFragment() {
            super("panel", "viewFragment", (MarkupContainer)CustomStatsSettingPage.this);
            this.setOutputMarkupId(true);
            ArrayList columns = Lists.newArrayList();
            columns.add(new TablePropertyColumn("Category", "categoryName").setCssClass("nowrap-text"));
            columns.add(new TablePropertyColumn("Description", "description").setCssClass("text"));
            columns.add(new TablePropertyColumn("Ordinal", "ordinal", "ordinal"));
            columns.add(new AbstractTableColumn<CustomStatsCategory>((IModel)Model.of((Serializable)((Object)"Actions"))){
                private static final long serialVersionUID = 1L;

                public void populateItem(Item<ICellPopulator<CustomStatsCategory>> cellItem, String componentId, IModel<CustomStatsCategory> rowModel) {
                    cellItem.add(new Component[]{new RowFragment(componentId, rowModel)});
                }
            }.setCssClass("nowrap-text"));
            LoadableDetachableModel<List<CustomStatsCategory>> model = new LoadableDetachableModel<List<CustomStatsCategory>>(){
                private static final long serialVersionUID = 1L;

                protected List<CustomStatsCategory> load() {
                    PluginSetting ps = PluginSetting.get();
                    Map<String, CustomStatsCategory> categories = ps.getSettings();
                    ArrayList result = Lists.newArrayList(categories.values());
                    Collections.sort(result, new Comparator<CustomStatsCategory>(){

                        @Override
                        public int compare(CustomStatsCategory o1, CustomStatsCategory o2) {
                            return o1.getCategoryName().compareTo(o2.getCategoryName());
                        }
                    });
                    return result;
                }
            };
            ListDataProvider provider = new ListDataProvider((IModel)model);
            DataTable<CustomStatsCategory> table = new DataTable<CustomStatsCategory>("categories", (List)columns, (IDataProvider)provider, Integer.MAX_VALUE){
                private static final long serialVersionUID = 1L;

                protected Item<CustomStatsCategory> newRowItem(String id, int index, IModel<CustomStatsCategory> model) {
                    return new OddEvenItem(id, index, model);
                }

                protected Item<IColumn<CustomStatsCategory>> newCellItem(String id, int index, IModel<IColumn<CustomStatsCategory>> model) {
                    Item item = super.newCellItem(id, index, model);
                    String sortProperty = ((IColumn)this.getColumns().get(index)).getSortProperty();
                    SortParam sort = ((ListDataProvider)this.getDataProvider()).getSort();
                    if (sortProperty != null && sort != null && Objects.equal((Object)sortProperty, (Object)sort.getProperty())) {
                        item.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"ordered")))});
                    }
                    return item;
                }
            };
            table.setOutputMarkupId(true);
            table.addTopToolbar((AbstractToolbar)new HeadersToolbar((DataTable)table, (ISortStateLocator)provider));
            table.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar((DataTable)table, (IModel)Model.of((Serializable)((Object)"No category defined"))));
            this.add(new Component[]{table});
            Link<Void> addLink = new Link<Void>("addLink"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    CustomStatsSettingPage.this.setEditorMode(Mode.CREATE, "Add new category", new CustomStatsCategory());
                }
            };
            this.add(new Component[]{addLink});
            AjaxLink<Void> removeLink = new AjaxLink<Void>("removeLink", (DataTable)table){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ DataTable val$table;
                {
                    this.val$table = dataTable;
                    super(x0);
                }

                public void onClick(AjaxRequestTarget target) {
                    PluginSetting s = (PluginSetting)PluginSettingHelper.getSetting(CustomStatsPlugin.class, (boolean)false);
                    if (s == null) {
                        s = new PluginSetting();
                    }
                    String previousAuditContent = VersionedDocument.fromBean((Object)s).toXML();
                    s = new PluginSetting();
                    PluginSettingHelper.saveSetting(CustomStatsPlugin.class, (Object)s);
                    AuditManager.instance.audit("Administration::Plugin", "Custom stats setting was modified.", VersionedDocument.fromBean((Object)s).toXML(), previousAuditContent);
                    target.add(new Component[]{this.val$table});
                }
            };
            removeLink.add(new Behavior[]{new ConfirmBehavior("Are you sure you want to remove all categories?")});
            this.add(new Component[]{removeLink});
        }
    }

    static enum Mode {
        VIEW,
        CREATE,
        EDIT,
        COPY;

    }
}

