/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.setting;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsCategory;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsPlugin;
import com.pmease.quickbuild.plugin.report.customstats.PluginSetting;
import com.pmease.quickbuild.plugin.report.customstats.setting.CustomStatsSettingPage;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;

public class CategoryEditor
extends Panel {
    private static final long serialVersionUID = 1L;

    public CategoryEditor(String id, final CustomStatsSettingPage.Mode mode, String title, CustomStatsCategory category, final CustomStatsSettingPage parentPanel) {
        super(id);
        this.setOutputMarkupId(true);
        this.add(new Component[]{new Label("title", title)});
        final EditContext editContext = new EditContext((Object)category);
        final String oldId = mode == CustomStatsSettingPage.Mode.CREATE ? null : category.getCategoryId();
        Form form = new Form("form");
        BeanEditor editor = new BeanEditor("editor", editContext);
        form.add(new Component[]{editor});
        Button submitButton = new Button("submit"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                editContext.validate(false);
                if (editContext.hasError()) {
                    this.getSession().error((Serializable)((Object)"Please fix below errors."));
                    return;
                }
                CustomStatsCategory setting = new CustomStatsCategory();
                editContext.update((Object)setting);
                setting.setCategoryId(Tab.title2id((String)setting.getCategoryName()).toLowerCase());
                PluginSetting pluginSetting = (PluginSetting)PluginSettingHelper.getSetting(CustomStatsPlugin.class, (boolean)false);
                if (pluginSetting == null) {
                    pluginSetting = new PluginSetting();
                }
                String previousAuditContent = VersionedDocument.fromBean((Object)pluginSetting).toXML();
                switch (mode) {
                    case CREATE: 
                    case COPY: {
                        if (!pluginSetting.hasCategory(setting.getCategoryId())) break;
                        editContext.getProperty("categoryName").setError("The category name is already used.");
                        this.getSession().error((Serializable)((Object)"Please fix below errors."));
                        return;
                    }
                    case EDIT: {
                        if (setting.getCategoryId().equalsIgnoreCase(oldId)) break;
                        if (pluginSetting.hasCategory(setting.getCategoryId())) {
                            editContext.getProperty("categoryName").setError("The category name is already used.");
                            this.getSession().error((Serializable)((Object)"Please fix below errors."));
                            return;
                        }
                        pluginSetting.removeCategory(oldId);
                        break;
                    }
                }
                pluginSetting.addCategory(setting);
                PluginSettingHelper.saveSetting(CustomStatsPlugin.class, (Object)pluginSetting);
                AuditManager.instance.audit("Administration::Plugin", "Custom stats setting was modified.", VersionedDocument.fromBean((Object)pluginSetting).toXML(), previousAuditContent);
                parentPanel.setViewMode();
                this.getSession().info((Serializable)((Object)"Setting saved."));
            }
        };
        form.add(new Component[]{submitButton});
        form.setDefaultButton((IFormSubmittingComponent)submitButton);
        form.add(new Component[]{new Link<Void>("cancel"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                parentPanel.setViewMode();
            }
        }});
        this.add(new Component[]{form});
    }
}

