/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsCategory;
import com.pmease.quickbuild.plugin.report.customstats.DataColumnDef;
import com.pmease.quickbuild.plugin.report.customstats.PluginSetting;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CustomStatsTablePanel
extends AbstractReportPanel {
    private static final long serialVersionUID = 1L;

    public CustomStatsTablePanel(String id, AbstractRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
        String categoryName = renderer.getCategory().getName();
        CustomStatsCategory setting = PluginSetting.getCategoryDefByName(categoryName);
        this.add(new Component[]{new ListView<DataColumnDef>("items", setting.getColumns()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<DataColumnDef> item) {
                DataColumnDef column = (DataColumnDef)item.getModelObject();
                item.add(new Component[]{new Label("title", column.getDisplayName())});
                Label label = new Label("primaryValue", CustomStatsTablePanel.this.getValueAsString(column));
                String color = CustomStatsTablePanel.this.getColor(column);
                if (!Strings.isNullOrEmpty((String)color)) {
                    label.add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)("color:" + color))), ";")});
                }
                if (item.getIndex() == 0) {
                    item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"first")), " ")});
                }
                if (item.getIndex() == this.getList().size() - 1) {
                    item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"last")), " ")});
                }
                item.add(new Component[]{label});
            }
        }});
    }

    private String getColor(DataColumnDef column) {
        String colorExp = column.getColor();
        if (Strings.isNullOrEmpty((String)colorExp)) {
            return null;
        }
        if (colorExp.indexOf(35) == 0) {
            return colorExp;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        DataReport report = this.getDefaultReport();
        for (DataRow each : report.getRows()) {
            map.put(each.getValueAsString("indName"), each.getValue("indValue"));
        }
        ScriptEngine se = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        return se.interpolate(colorExp, map);
    }

    private String getValueAsString(DataColumnDef column) {
        DataReport report = this.getDefaultReport();
        for (DataRow each : report.getRows()) {
            String name = each.getValueAsString("indName");
            if (!column.getColumnName().equalsIgnoreCase(name)) continue;
            return column.dataType().asString(each.getValue("indValue"));
        }
        return "N/A";
    }
}

