/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.renderer;

import com.pmease.quickbuild.plugin.report.customstats.CustomStatsCategory;
import com.pmease.quickbuild.plugin.report.customstats.DataColumnDef;
import com.pmease.quickbuild.plugin.report.customstats.renderer.CustomStatsStatisticsPanel;
import com.pmease.quickbuild.plugin.report.customstats.renderer.MetricItem;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class CustomStatsStatisticsRenderer
extends StatisticsRenderer {
    private static final long serialVersionUID = 1L;

    public CustomStatsStatisticsRenderer(CustomStatsCategory def, ReportCategory category) {
        super(category);
        this.setMode(RendererMode.STATISTICS);
        this.init(def);
    }

    protected void init(CustomStatsCategory def) {
        for (DataColumnDef each : def.getColumns()) {
            MetricItem item = new MetricItem(this.category, each.getColumnName());
            item.setDataType(each.dataType());
            item.setReportName("stats");
            item.setValueExpression("indValue");
            item.setTitle(each.getDisplayName());
            item.setTabName(each.getDisplayName());
            this.getItems().add(item);
        }
    }

    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new CustomStatsStatisticsPanel(id, this, model){

            protected Component createStatsHeader(String id) {
                if (CustomStatsStatisticsRenderer.this.isSimpleMode()) {
                    return null;
                }
                return super.createStatsHeader(id);
            }

            protected Component createGraphControls(String id) {
                if (CustomStatsStatisticsRenderer.this.isSimpleMode()) {
                    return null;
                }
                return super.createGraphControls(id);
            }

            protected Component createExtraControls(String id) {
                if (CustomStatsStatisticsRenderer.this.isSimpleMode()) {
                    return null;
                }
                return super.createExtraControls(id);
            }

            protected Component createStatsSummary(String id) {
                if (CustomStatsStatisticsRenderer.this.isSimpleMode()) {
                    return null;
                }
                return super.createStatsSummary(id);
            }

            protected Component createStatsDetails(String id) {
                if (CustomStatsStatisticsRenderer.this.isSimpleMode()) {
                    return null;
                }
                return super.createStatsDetails(id);
            }
        };
    }
}

