/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.publisher;

import com.pmease.quickbuild.extensionpoint.StatisticsSupport;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.customstats.PluginSetting;
import com.pmease.quickbuild.plugin.report.customstats.publisher.CustomStatsPublisher;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class CustomStatsProvider
implements StatisticsSupport {
    public void collectStatistics(Build build) {
        List<ReportCategory> categories = PluginSetting.getCategories();
        if (categories.isEmpty()) {
            return;
        }
        for (ReportCategory each : categories) {
            File dir = each.getCategoryDirOfBuild(build);
            if (!dir.exists()) continue;
            CustomStatsPublisher publisher = new CustomStatsPublisher(each);
            publisher.collectStatistics(build);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupStatistics(Configuration configuration) {
        List<ReportCategory> categories = PluginSetting.getCategories();
        for (ReportCategory each : categories) {
            File dir = each.getCategoryDirOfStats(configuration);
            Lock lock = LockUtils.lockForWrite((File)dir);
            try {
                FileUtils.deleteDir((File)dir);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public String getStatisticsName() {
        return "Custom Statistics";
    }
}

