/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.publisher;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.plugin.report.customstats.CustomReportCategory;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsCategory;
import com.pmease.quickbuild.plugin.report.customstats.DataColumnDef;
import com.pmease.quickbuild.plugin.report.customstats.PluginSetting;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.UnProcessedReport;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.hibernate.validator.constraints.NotEmpty;
import org.xml.sax.SAXException;

@Editable(category={"Publish"}, name="Custom Statistics Report", description="Publish custom statistics reports")
@ScriptApi(value="This step publishes the original custom statistics XML files.")
public class CustomStatsBuildStep
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    private String categoryId;
    @XStreamOmitField
    private Map<String, Object> stats;

    @Editable(order=500, name="Statistics Category", description="Select a custom statistics category to be published")
    @ChoiceProvider(value="getCategoryNames")
    @NotEmpty
    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    protected void doPublish() {
        GeneratorContext context = GeneratorContext.getContext();
        File[] files = (File[])Iterables.toArray((Iterable)FileUtils.listFiles((File)context.getSourceDir(), (String)this.getFilePattern()), File.class);
        if (files.length == 0) {
            return;
        }
        this.stats = new HashMap<String, Object>();
        CustomStatsCategory setting = PluginSetting.getCategoryDefByName(this.getCategoryId());
        if (setting == null) {
            throw new QuickbuildException("No category " + this.getCategoryId() + " is defined in custom stats plugin setting.");
        }
        for (File each : files) {
            if (!each.exists() || each.length() == 0L) {
                Context.getLogger().warn("File " + each + " is empty, ignore processing.");
                continue;
            }
            try {
                Document doc = XMLHelper.readXML((File)each);
                for (DataColumnDef column : setting.getColumns()) {
                    String str = doc.valueOf(column.getXpath());
                    if (Strings.isNullOrEmpty((String)str)) continue;
                    Object obj = column.dataType().fromString(str, null);
                    Double value = ((Number)obj).doubleValue();
                    if (value == null || value.isNaN()) {
                        value = 0.0;
                    }
                    value = value + (Double)DataTypes.DOUBLE.typeCast((Object)MapUtils.getNumber(this.stats, (Object)column.getColumnName(), (Number)0));
                    this.stats.put(column.getColumnName(), column.dataType().typeCast((Object)value));
                }
            }
            catch (Exception e) {
                Throwable de = ExceptionUtils.extractException((Throwable)e, DocumentException.class);
                Throwable sax = ExceptionUtils.extractException((Throwable)e, SAXException.class);
                if (de != null || sax != null) {
                    Context.getLogger().warn("Processing file " + each + " failed.", (Throwable)e);
                    this.processMalFormedReport(each, e);
                    continue;
                }
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        if (this.stats.isEmpty()) {
            return;
        }
        CustomReportCategory category = setting.toCategory();
        DataReport report = category.createReport("stats");
        Long buildId = Context.getBuild().getId();
        for (DataColumnDef column : setting.getColumns()) {
            DataRow row = report.addRow();
            row.setValue("buildId", (Object)buildId);
            row.setValue("indName", (Object)column.getColumnName());
            double value = (Double)DataTypes.DOUBLE.typeCast(MapUtils.getObject(this.stats, (Object)column.getColumnName(), (Object)0.0));
            if ("PERCENT".equalsIgnoreCase(column.getDataType())) {
                row.setValue("indValue", (Object)(value / (double)files.length));
                this.stats.put(column.getColumnName(), value);
                continue;
            }
            row.setValue("indValue", (Object)value);
        }
        File dbDir = context.getWorkingDir();
        category.saveReport(dbDir, report, null);
    }

    private void processMalFormedReport(File file, Exception e) {
        UnProcessedReport r = GeneratorContext.getContext().getUnProcessedReport();
        String reportset = this.getReportsetName();
        String fileName = file.getName();
        if (StringUtils.isEmpty((String)reportset)) {
            reportset = "DEFAULT";
        }
        DataRow row = null;
        for (DataRow each : r.getRows()) {
            String rs = each.getValueAsString("REPORT_SET");
            String fn = each.getValueAsString("FILE_NAME");
            if (!Objects.equal((Object)reportset, (Object)rs) || !Objects.equal((Object)fileName, (Object)fn)) continue;
            row = each;
            break;
        }
        if (row != null) {
            return;
        }
        row = r.addRow();
        row.setValue("REPORT_SET", (Object)reportset);
        row.setValue("FILE_NAME", (Object)file.getName());
        String content = FileUtils.readFileAsString((File)file);
        row.setValue("CONTENT", (Object)content);
        row.setValue("REASON", (Object)org.apache.commons.lang.exception.ExceptionUtils.getMessage((Throwable)e));
    }

    public ReportCategory getCategory() {
        return (ReportCategory)Preconditions.checkNotNull((Object)PluginSetting.getCategoryByName(this.getCategoryId()), (Object)("category [" + this.getCategoryId() + "] does not exist"));
    }

    private static List<String> getCategoryNames() {
        return PluginSetting.getCategoryNames();
    }

    protected void saveStatsReport() {
    }

    protected String getStatsReportName() {
        return "stats";
    }

    protected boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @ScriptApi(value="The statistics data which have been defined in plugin setting.")
    public Map<String, Object> getStats() {
        return this.stats;
    }

    public void setStats(Map<String, Object> stats) {
        this.stats = stats;
    }
}

