/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.migration;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsCategory;
import com.pmease.quickbuild.plugin.report.customstats.DataColumnDef;
import com.pmease.quickbuild.plugin.report.customstats.PluginSetting;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public class CustomStatsMigrator
extends ReportCategoryMigrator {
    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        ReportCategory category = context.getCategory();
        Build build = context.getBuild();
        File categoryDir = context.getDir();
        Configuration c = build != null ? build.getConfiguration() : context.getConfiguration();
        Preconditions.checkNotNull((Object)c, (Object)"Configuration should not be null.");
        CustomStatsCategory def = PluginSetting.getCategoryDefById(category.getId());
        if (def == null) {
            throw new QuickbuildException("No report category " + category.getId() + " defined in configuration ");
        }
        ReportCategory old = CustomStatsMigrator.createCategory(def);
        List<DataColumnDef> columns = def.getColumns();
        String[] reportsets = old.getReportSets(categoryDir);
        if (reportsets.length == 0) {
            return;
        }
        if (build != null) {
            for (String each : reportsets) {
                File reportDir = new File(categoryDir, each);
                DataReport report = old.createReport("stats-build");
                File reportFile = new File(reportDir, report.getOutputName());
                if (!reportFile.exists()) continue;
                report.loadFromXML(reportFile);
                CaseInsensitiveMap map = CaseInsensitiveMap.create();
                for (DataRow row : report.getRows()) {
                    for (DataColumnDef column : columns) {
                        Object obj = row.getValue(column.getColumnName());
                        Double d = (Double)DataTypes.DOUBLE.typeCast(obj);
                        if (map.containsKey(column.getColumnName())) {
                            Double current = (Double)map.get(column.getColumnName());
                            d = d + current;
                        }
                        map.put(column.getColumnName(), d);
                    }
                }
                DataReport statsReport = category.createReport("stats");
                for (String key : map.keySet()) {
                    DataRow row = statsReport.addRow();
                    row.setValue("buildId", (Object)build.getId());
                    row.setValue("indName", (Object)key);
                    row.setValue("indValue", map.get(key));
                }
                category.saveReport(reportDir, statsReport);
            }
        } else {
            for (String each : reportsets) {
                File reportDir = new File(categoryDir, each);
                Collection files = FileUtils.listFiles((File)reportDir, (String)"**/stats.xml");
                DataReport statsReport = category.createReport("stats");
                CaseInsensitiveMap indexes = CaseInsensitiveMap.create();
                for (File file : files) {
                    DataReport oldReport = old.createReport("stats");
                    oldReport.loadFromXML(file);
                    for (DataRow row : oldReport.getRows()) {
                        for (DataColumnDef column : columns) {
                            DataRow r;
                            Long buildId = row.getLong("buildId");
                            String columnName = column.getColumnName();
                            String key = buildId + ":" + columnName;
                            Integer i = (Integer)indexes.get(key);
                            if (i == null) {
                                r = statsReport.addRow();
                                indexes.put(key, statsReport.getRowsCount() - 1);
                            } else {
                                r = statsReport.getRow(i.intValue());
                            }
                            Double value = (Double)DataTypes.DOUBLE.typeCast(row.getValue(column.getColumnName()));
                            r.setValue("buildId", row.getValue("buildId"));
                            r.setValue("indName", (Object)column.getColumnName());
                            r.setValue("indValue", (Object)value);
                        }
                    }
                }
                category.saveReport(reportDir, statsReport);
            }
        }
    }

    static ReportCategory createCategory(CustomStatsCategory c) {
        ReportCategory category = new ReportCategory();
        category.setId(c.getCategoryId());
        category.setName(c.getCategoryName());
        category.setOrder(c.getOrdinal());
        ReportMetaData statsMeta = CustomStatsMigrator.createMeta(c);
        statsMeta.setGroup(ReportGroup.BUILD);
        statsMeta.setReportName("stats-build");
        category.addMeta(statsMeta);
        statsMeta = CustomStatsMigrator.createMeta(c);
        statsMeta.setGroup(ReportGroup.STATISTICS);
        statsMeta.setReportName("stats");
        category.addMeta(statsMeta);
        return category;
    }

    static ReportMetaData createMeta(CustomStatsCategory c) {
        ReportMetaData meta = new ReportMetaData();
        List<DataColumnDef> defs = c.getColumns();
        meta.addColumn(DataColumn.BUILD_ID_COLUMN);
        for (DataColumnDef each : defs) {
            meta.addColumn(each.toDataColumn());
        }
        return meta;
    }
}

