/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.gadget;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.customstats.CustomReportCategory;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsCategory;
import com.pmease.quickbuild.plugin.report.customstats.DataColumnDef;
import com.pmease.quickbuild.plugin.report.customstats.PluginSetting;
import com.pmease.quickbuild.plugin.report.customstats.gadget.ErrorStatisticsRenderer;
import com.pmease.quickbuild.plugin.report.customstats.gadget.GadgetStatisticsRenderer;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.LineChartGadget;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.web.component.editor.EditContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Custom Statistics History Gadget", order=100000, category={"Others"})
public class CustomStatsStatisticsGadget
extends LineChartGadget {
    private static final long serialVersionUID = 1L;
    private String categoryName;

    protected StatisticsRenderer createRenderer() {
        String name = this.getCategoryName();
        ReportCategory category = PluginSetting.getCategoryByName(name);
        if (category == null) {
            return new ErrorStatisticsRenderer();
        }
        GadgetStatisticsRenderer r = new GadgetStatisticsRenderer(PluginSetting.getCategoryDefByName(name), category);
        r.setSimpleMode(true);
        return r;
    }

    @Editable(name="Category Name", order=200)
    @ChoiceProvider(value="getCategoryNames")
    @NotEmpty
    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Editable(name="Indicators", order=400)
    @ChoiceProvider(value="getAvailableIndicators")
    @Size(min=1)
    public List<String> getIndicators() {
        return super.getIndicators();
    }

    private static List<String> getCategoryNames() {
        return PluginSetting.getCategoryNames();
    }

    private static CustomStatsCategory guessCategory() {
        String name = EditContext.EditableProperty.getValueAsString((String)"categoryName");
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        return PluginSetting.getCategoryDefByName(name);
    }

    private static List<String> getAvailableIndicators() {
        CustomStatsCategory c = CustomStatsStatisticsGadget.guessCategory();
        if (c == null) {
            return Collections.emptyList();
        }
        List<DataColumnDef> columns = c.getColumns();
        ArrayList result = Lists.newArrayList();
        for (DataColumnDef each : columns) {
            result.add(each.getColumnName());
        }
        return result;
    }

    @Editable(name="Report Sets", description="Specify the report sets you want to display, comma to separated. Leave empty if you want to display all repor sets")
    @ChoiceProvider(value="getAvailableReportsets")
    public List<String> getReportsets() {
        return super.getReportsets();
    }

    private static List<String> getAvailableReportsets(Class<?> clazz) {
        ArrayList<String> available = new ArrayList<String>();
        CustomStatsCategory category = CustomStatsStatisticsGadget.guessCategory();
        if (category == null) {
            return Collections.emptyList();
        }
        Configuration configuration = CustomStatsStatisticsGadget.guessConfiguration();
        if (configuration != null) {
            CustomReportCategory r = category.toCategory();
            return Lists.newArrayList((Object[])r.getReportSetsOfStats(configuration));
        }
        return available;
    }

    protected StatisticsItem getStatisticsItem(String name) {
        for (StatisticsItem each : this.getRenderer().getItems()) {
            if (!each.getTabName().equalsIgnoreCase(name)) continue;
            return each;
        }
        throw new QuickbuildException("Unable to find indicator " + name + " in renderer " + this.getRenderer().getId());
    }
}

