/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats.gadget;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.customstats.PluginSetting;
import com.pmease.quickbuild.plugin.report.customstats.gadget.ErrorBuildRenderer;
import com.pmease.quickbuild.plugin.report.customstats.renderer.CustomStatsTableRenderer;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.DashboardModule;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.DashboardTypeGadget;
import com.pmease.quickbuild.web.component.editor.EditContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Custom Statistics Build Gadget", order=100000, category={"Others"})
public class CustomStatsGadget
extends DashboardTypeGadget {
    private static final long serialVersionUID = 1L;
    private String categoryName;

    protected AbstractRenderer createContentRenderer() {
        String name = this.getCategoryName();
        ReportCategory category = PluginSetting.getCategoryByName(name);
        if (category == null) {
            return new ErrorBuildRenderer("No category named " + name + " found.");
        }
        return new CustomStatsTableRenderer(category);
    }

    protected void configureModule(DashboardModule module) {
        super.configureModule(module);
        module.setToUrl("/build/${build.getId()}/overview");
    }

    protected String getToTab() {
        return null;
    }

    protected String getModuleCss() {
        return "autoHeight";
    }

    @Editable(name="Category Name", order=700)
    @ChoiceProvider(value="getCategoryNames")
    @NotEmpty
    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    private static List<String> getCategoryNames() {
        return PluginSetting.getCategoryNames();
    }

    private static List<String> getAvailableReportsets(Class<?> clazz) {
        ArrayList<String> available = new ArrayList<String>();
        Build build = CustomStatsGadget.guessBuild();
        if (build != null) {
            try {
                CustomStatsGadget gadget = (CustomStatsGadget)((Object)clazz.newInstance());
                EditContext.EditableProperty property = EditContext.EditableProperty.get((String)"categoryName");
                String name = (String)property.getValue();
                if (Strings.isNullOrEmpty((String)name)) {
                    return Collections.emptyList();
                }
                ReportCategory category = PluginSetting.getCategoryByName(name);
                if (category == null) {
                    return Collections.emptyList();
                }
                available.addAll(Lists.newArrayList((Object[])category.getReportSetsOfBuild(build)));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return available;
    }

    @Editable(name="Report Sets Displayed", order=850, description="Specify the report sets to be displayed on this gadget. 0 to display all selected report sets")
    public int getReportsetsPerPage() {
        return super.getReportsetsPerPage();
    }
}

