/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsCategory;
import com.pmease.quickbuild.plugin.report.customstats.CustomStatsPlugin;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Editable(name="Custom Statistics")
public class PluginSetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, CustomStatsCategory> settings = CaseInsensitiveMap.create();

    public Map<String, CustomStatsCategory> getSettings() {
        return this.settings;
    }

    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    public static PluginSetting get() {
        return (PluginSetting)PluginSettingHelper.getSetting(CustomStatsPlugin.class, (boolean)true);
    }

    public void setSettings(Map<String, CustomStatsCategory> settings) {
        this.settings = settings;
    }

    public void addCategory(CustomStatsCategory category) {
        this.settings.put(category.getCategoryId(), category);
    }

    public void removeCategory(String categoryId) {
        this.settings.remove(categoryId);
    }

    public void removeCategory(CustomStatsCategory category) {
        this.removeCategory(category.getCategoryId());
    }

    public boolean hasCategory(String categoryId) {
        return this.settings.containsKey(categoryId);
    }

    public static CustomStatsCategory getCategoryDefById(String id) {
        PluginSetting ps = PluginSetting.get();
        if (ps == null) {
            return null;
        }
        Map<String, CustomStatsCategory> categories = ps.getSettings();
        return categories.get(id);
    }

    public static CustomStatsCategory getCategoryDefByName(String name) {
        PluginSetting ps = PluginSetting.get();
        if (ps == null) {
            return null;
        }
        Map<String, CustomStatsCategory> categories = ps.getSettings();
        for (CustomStatsCategory each : categories.values()) {
            if (!each.getCategoryName().equalsIgnoreCase(name)) continue;
            return each;
        }
        return null;
    }

    public static ReportCategory getCategoryById(String id) {
        CustomStatsCategory def = PluginSetting.getCategoryDefById(id);
        if (def == null) {
            return null;
        }
        return def.toCategory();
    }

    public static ReportCategory getCategoryByName(String name) {
        CustomStatsCategory def = PluginSetting.getCategoryDefByName(name);
        if (def == null) {
            return null;
        }
        return def.toCategory();
    }

    public static List<String> getCategoryNames() {
        PluginSetting ps = PluginSetting.get();
        if (ps == null) {
            return Collections.emptyList();
        }
        Map<String, CustomStatsCategory> defs = ps.getSettings();
        ArrayList names = Lists.newArrayList();
        for (CustomStatsCategory each : defs.values()) {
            names.add(each.getCategoryName());
        }
        Collections.sort(names);
        return names;
    }

    public static List<ReportCategory> getCategories() {
        PluginSetting defs = PluginSetting.get();
        if (defs == null) {
            return Collections.emptyList();
        }
        ArrayList categories = Lists.newArrayList();
        for (CustomStatsCategory each : defs.settings.values()) {
            categories.add(each.toCategory());
        }
        return categories;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.settings).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginSetting other = (PluginSetting)obj;
        return new EqualsBuilder().append(this.settings, other.settings).isEquals();
    }
}

