/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats;

import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Color;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(description="The column definition")
public class DataColumnDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String columnName;
    private String displayName;
    private String dataType = "INTEGER";
    private String xpath;
    private String color;

    @Editable(order=100, name="Indicator Id", description="The id of this indicator. Input a string for this field. Don't contain any space here. For example, id 'ClassName' is valid, while 'Class Name' isn't.")
    @Pattern(regexp="[A-Za-z0-9_]+", message="Only characters and digital characters are allowed here")
    @NotEmpty
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Editable(order=200, name="Display Name", description="The display name for an indicator which will be displayed at statistics page.")
    @NotEmpty
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Editable(order=300, name="Data Type")
    @NotEmpty
    @ChoiceProvider(value="getDataTypes")
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Editable(order=400, name="XPath", description="The xpath which QuickBuild will use to evaluate the statistics data")
    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    @Editable(order=400, name="Color", description="Define the display color on build overview. Color value should use css format '#RRGGBB'.")
    @Scriptable
    @Color
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public DataColumn toDataColumn() {
        DataColumn column = new DataColumn(this.columnName, DataTypes.getDataType((String)this.dataType));
        column.setDisplayName(this.getDisplayName());
        return column;
    }

    public DataType dataType() {
        return DataTypes.getDataType((String)this.getDataType());
    }

    private static List<String> getDataTypes() {
        return Arrays.asList("INTEGER", "LONG", "DOUBLE", "DURATION", "PERCENT");
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.columnName).append((Object)this.displayName).append((Object)this.dataType).append((Object)this.xpath).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataColumnDef other = (DataColumnDef)obj;
        return new EqualsBuilder().append((Object)this.columnName, (Object)other.columnName).append((Object)this.displayName, (Object)other.displayName).append((Object)this.dataType, (Object)other.dataType).append((Object)this.xpath, (Object)other.xpath).isEquals();
    }

    public String toString() {
        return this.columnName + " (" + this.displayName + ", " + this.dataType + ", " + this.xpath + ")";
    }
}

