/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.customstats;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.customstats.CustomReportCategory;
import com.pmease.quickbuild.plugin.report.customstats.DataColumnDef;
import com.pmease.quickbuild.plugin.report.customstats.renderer.CustomStatsStatisticsRenderer;
import com.pmease.quickbuild.plugin.report.customstats.renderer.CustomStatsSummaryRenderer;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.validator.constraints.NotEmpty;

public class CustomStatsCategory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String categoryId;
    private int ordinal = 900;
    private String categoryName;
    private String description;
    private List<DataColumnDef> columns = Lists.newArrayList();

    public String getCategoryId() {
        if (this.categoryId == null) {
            return Tab.title2id((String)this.getCategoryName()).toLowerCase();
        }
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public boolean hasBuildReport(Build build) {
        if (build == null) {
            return false;
        }
        File file = new File(build.getPublishDir(), "reports/" + this.getCategoryId());
        return file.exists();
    }

    public boolean hasStatsReport(Configuration configuration) {
        if (configuration == null) {
            return false;
        }
        File file = new File(configuration.getPublishDir(), "reports/" + this.getCategoryId());
        return file.exists();
    }

    @Editable(order=200, name="Category Name", description="The name of this category which will be displayed as a tab name in Statistics page.")
    @NotEmpty
    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Editable(order=300, name="Ordinal", description="The order when displayed in statistics tab")
    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Editable(order=320, name="Description")
    @Multiline
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(order=400, name="Indicators", description="The indicators which you want to collect.")
    @Size(min=1, max=200)
    public List<DataColumnDef> getColumns() {
        return this.columns;
    }

    public void setColumns(List<DataColumnDef> columns) {
        this.columns = columns;
    }

    public CustomReportCategory toCategory() {
        CustomReportCategory category = new CustomReportCategory();
        category.setId(this.getCategoryId());
        category.setName(this.getCategoryName());
        category.setOrder(this.getOrdinal());
        CustomStatsStatisticsRenderer renderer = new CustomStatsStatisticsRenderer(this, category);
        renderer.setId("renderStats");
        category.getRendererRepository().addRenderer((AbstractRenderer)renderer);
        CustomStatsSummaryRenderer summaryRenderer = new CustomStatsSummaryRenderer(category);
        summaryRenderer.setId("renderBuildSummary");
        category.getRendererRepository().addRenderer((AbstractRenderer)summaryRenderer);
        return category;
    }

    public ReportMetaData createMeta() {
        ReportMetaData meta = new ReportMetaData();
        meta.setGroup(ReportGroup.STATISTICS);
        meta.addColumn(DataColumn.BUILD_ID_COLUMN);
        for (DataColumnDef def : this.columns) {
            DataColumn col = def.toDataColumn();
            meta.addColumn(col);
        }
        return meta;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.categoryId).append((Object)this.categoryName).append(this.ordinal).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomStatsCategory other = (CustomStatsCategory)obj;
        return new EqualsBuilder().append((Object)this.categoryId, (Object)other.categoryId).append((Object)this.categoryName, (Object)other.categoryName).append(this.ordinal, other.ordinal).isEquals();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.categoryId).append(" (").append(this.categoryName).append(")");
        sb.append("[");
        for (DataColumnDef def : this.columns) {
            sb.append(def).append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

