/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.fxcop.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.fxcop.Level;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class IssuesReportProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;

    public IssuesReportProcessor(ReportCategory category) {
        super(category);
    }

    protected void processCurrentElement() {
        GeneratorContext context = this.getContext();
        Element currentElement = context.getCurrentElement();
        DataRow destRow = context.getDestRow();
        destRow.setValue("IssueName", (Object)currentElement.valueOf("./@Name"));
        destRow.setValue("Certainty", (Object)currentElement.valueOf("./@Certainty"));
        String str = currentElement.valueOf("./@Level");
        Level level = Level.CriticalError;
        if (!StringUtils.isEmpty((String)str)) {
            level = str.startsWith("CriticalError") ? Level.CriticalError : (str.startsWith("Error") ? Level.Error : (str.startsWith("CriticalWarning") ? Level.CriticalWarning : (str.startsWith("Warning") ? Level.Warning : Level.Information)));
            destRow.setValue("Level", (Object)level);
        }
        destRow.setValue("Resolution", (Object)currentElement.valueOf("."));
        Element parentNode = currentElement.getParent();
        destRow.setValue("TypeName", (Object)parentNode.valueOf("./@TypeName"));
        destRow.setValue("Category", (Object)parentNode.valueOf("./@Category"));
        destRow.setValue("CheckId", (Object)parentNode.valueOf("./@CheckId"));
        destRow.setValue("Status", (Object)parentNode.valueOf("./@Status"));
        destRow.setValue("FixCategory", (Object)parentNode.valueOf("./@FixCategory"));
        do {
            String parentNodeName;
            if ("Namespace".equalsIgnoreCase(parentNodeName = parentNode.getName())) {
                destRow.setValue("NamespaceName", (Object)parentNode.valueOf("./@Name"));
                continue;
            }
            if ("Member".equalsIgnoreCase(parentNodeName)) {
                destRow.setValue("MemberName", (Object)parentNode.valueOf("./@Name"));
                continue;
            }
            if ("Resource".equalsIgnoreCase(parentNodeName)) {
                destRow.setValue("ResourceName", (Object)parentNode.valueOf("./@Name"));
                continue;
            }
            if ("Type".equalsIgnoreCase(parentNodeName)) {
                destRow.setValue("ClassName", (Object)parentNode.valueOf("./@Name"));
                continue;
            }
            if ("Module".equalsIgnoreCase(parentNodeName)) {
                destRow.setValue("ModuleName", (Object)parentNode.valueOf("./@Name"));
                continue;
            }
            if (!"Target".equalsIgnoreCase(parentNodeName)) continue;
            destRow.setValue("TargetName", (Object)parentNode.valueOf("./@Name"));
        } while ((parentNode = parentNode.getParent()) != null);
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

