/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.fxcop.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import org.dom4j.Element;

public class FxcopNameRule
extends AbstractRule {
    private static final long serialVersionUID = 1L;

    public FxcopNameRule(ReportCategory category) {
        super(category);
    }

    protected void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        Element element = context.getCurrentElement();
        for (Element parentElement = element.getParent(); parentElement != null; parentElement = parentElement.getParent()) {
            String parentNodeName = parentElement.getName();
            String name = parentElement.valueOf("./@Name");
            if ("Namespace".equalsIgnoreCase(parentNodeName)) {
                destRow.setValue("NamespaceName", (Object)name);
                continue;
            }
            if ("Member".equalsIgnoreCase(parentNodeName)) {
                destRow.setValue("MemberName", (Object)name);
                continue;
            }
            if ("Resource".equalsIgnoreCase(parentNodeName)) {
                destRow.setValue("ResourceName", (Object)name);
                continue;
            }
            if ("Type".equalsIgnoreCase(parentNodeName)) {
                destRow.setValue("ClassName", (Object)name);
                continue;
            }
            if ("Module".equalsIgnoreCase(parentNodeName)) {
                destRow.setValue("ModuleName", (Object)name);
                continue;
            }
            if (!"Target".equalsIgnoreCase(parentNodeName)) continue;
            destRow.setValue("TargetName", (Object)name);
        }
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

