/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.fxcop;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.fxcop.FxcopPlugin;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.MapUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="Fxcop Report", description="Publish Fxcop reports")
@ScriptApi(value="This step publishes the original Fxcop XML files.")
public class FxcopPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int messages;
    @XStreamOmitField
    private int criticalErrors;
    @XStreamOmitField
    private int errors;
    @XStreamOmitField
    private int criticalWarnings;
    @XStreamOmitField
    private int warnings;
    @XStreamOmitField
    private int informations;

    public FxcopPublisher() {
        this.setStepFailureCondition("false");
        this.setStepFailureMessage("");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(FxcopPlugin.class);
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"allIssuesUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"all_issues", (String)reportsetName)).build();
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"I don't care", "false"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    protected String getStatsReportName() {
        return "stats";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        DataReport statsReport = category.createReport("stats");
        File dbDir = context.getWorkingDir();
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "FxcopPublisher::saveStatsReport");
            Map stats = category.getDefaultStats(db, "targets", new Filter[0]);
            DataRow row = statsReport.addRow();
            row.setValue("buildId", (Object)Context.getBuild().getId());
            row.fromMap(stats);
            this.messages = MapUtils.getLong((Map)stats, (Object)"Messages", (Long)0L).intValue();
            this.criticalErrors = MapUtils.getLong((Map)stats, (Object)"CriticalErrors", (Long)0L).intValue();
            this.criticalWarnings = MapUtils.getLong((Map)stats, (Object)"CriticalWarnings", (Long)0L).intValue();
            this.errors = MapUtils.getLong((Map)stats, (Object)"Errors", (Long)0L).intValue();
            this.informations = MapUtils.getLong((Map)stats, (Object)"Informations", (Long)0L).intValue();
            this.warnings = MapUtils.getLong((Map)stats, (Object)"Warnings", (Long)0L).intValue();
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @ScriptApi(value="Total messages in Fxcop report.")
    public int getMessages() {
        return this.messages;
    }

    public void setMessages(int messages) {
        this.messages = messages;
    }

    @ScriptApi(value="Total critical errors in Fxcop report.")
    public int getCriticalErrors() {
        return this.criticalErrors;
    }

    public void setCriticalErrors(int criticalErrors) {
        this.criticalErrors = criticalErrors;
    }

    @ScriptApi(value="Total errors in Fxcop report.")
    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    @ScriptApi(value="Total critical warnings in Fxcop report.")
    public int getCriticalWarnings() {
        return this.criticalWarnings;
    }

    public void setCriticalWarnings(int criticalWarnings) {
        this.criticalWarnings = criticalWarnings;
    }

    @ScriptApi(value="Total warnings in Fxcop report.")
    public int getWarnings() {
        return this.warnings;
    }

    public void setWarnings(int warnings) {
        this.warnings = warnings;
    }

    @ScriptApi(value="Total informations in Fxcop report.")
    public int getInformations() {
        return this.informations;
    }

    public void setInformations(int informations) {
        this.informations = informations;
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        FxcopPublisher.removeElement((VersionedDocument)dom, (String)"messages");
        FxcopPublisher.removeElement((VersionedDocument)dom, (String)"criticalErrors");
        FxcopPublisher.removeElement((VersionedDocument)dom, (String)"errors");
        FxcopPublisher.removeElement((VersionedDocument)dom, (String)"criticalWarnings");
        FxcopPublisher.removeElement((VersionedDocument)dom, (String)"warnings");
        FxcopPublisher.removeElement((VersionedDocument)dom, (String)"informations");
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return FxcopChecksum.class;
    }

    public static class FxcopChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(FxcopPlugin.class);
        }
    }
}

