/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.xcode;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.log.BuildLogEntry;
import com.pmease.quickbuild.plugin.builder.xcode.PluginSetting;
import com.pmease.quickbuild.plugin.builder.xcode.XcodeLogger;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

@Editable(name="Xcode", category={"Build"}, description="Build Xcode project")
public class XcodeStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String target;
    private String project;
    private String sdk;
    private String scheme;
    private String configuration;
    private String arch;
    private String workspace;
    private String buildActions = "clean build";
    private String additionalParams;

    public void run() {
        ArrayList errorMessages;
        XcodeLogger logger;
        File workspaceDir;
        Commandline cmd = this.buildCommand();
        Commandline.ExecuteResult result = cmd.execute(workspaceDir = Context.getBuild().getConfiguration().getWorkspaceDir().getAbsoluteFile(), (OutputStream)((Object)(logger = new XcodeLogger())), new LineConsumer(errorMessages = Lists.newArrayList()){
            final /* synthetic */ List val$errorMessages;
            {
                this.val$errorMessages = list;
            }

            public void consume(String line) {
                if (!Strings.isNullOrEmpty((String)line)) {
                    this.val$errorMessages.add(line);
                }
                Context.getLogger().error(line);
            }
        });
        if (result.getReturnCode() != 0) {
            StringBuffer sb = new StringBuffer("Executing command [").append(cmd).append("] failed:\n");
            String logError = logger.getErrorMessage();
            String errorOutput = errorMessages.isEmpty() ? null : Joiner.on((String)"\n").skipNulls().join((Iterable)errorMessages);
            boolean hasError = false;
            if (!Strings.isNullOrEmpty((String)errorOutput)) {
                sb.append(errorOutput).append("\n");
                hasError = true;
            }
            if (!Strings.isNullOrEmpty((String)logError)) {
                sb.append(logError);
                hasError = true;
            }
            if (!hasError) {
                sb.append("See detailed error in the build log");
            }
            throw new QuickbuildException(sb.toString());
        }
    }

    private Commandline buildCommand() {
        Commandline cmd = new Commandline();
        cmd.setExecutable(this.getExecutable());
        XcodeStep.addArgument(cmd, "target", this.getTarget());
        XcodeStep.addArgument(cmd, "project", this.getProject());
        XcodeStep.addArgument(cmd, "sdk", this.getSdk());
        XcodeStep.addArgument(cmd, "scheme", this.getScheme());
        XcodeStep.addArgument(cmd, "configuration", this.getConfiguration());
        XcodeStep.addArgument(cmd, "arch", this.getArch());
        XcodeStep.addArgument(cmd, "workspace", this.getWorkspace());
        if (!Strings.isNullOrEmpty((String)this.getAdditionalParams())) {
            cmd.addArgLine(this.getAdditionalParams());
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getBuildActions()) ? 1 : 0) != 0);
        cmd.addArgLine(this.getBuildActions());
        return cmd;
    }

    public String renderLogAsHtml(BuildLogEntry logEntry, boolean showStep) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss,SSS");
        sdf.setTimeZone(Context.getTimeZone());
        StringBuffer buffer = new StringBuffer();
        buffer.append("<div class='log-entry log-").append(logEntry.getLogLevel().name().toLowerCase()).append("'>");
        buffer.append(sdf.format(logEntry.getDate()));
        if (showStep) {
            buffer.append(" [" + (logEntry.getStepPath() != null ? logEntry.getStepPath() : "") + "@" + logEntry.getNodeAddress() + "]");
        }
        buffer.append("&nbsp;" + logEntry.getLogLevel().align().replace(" ", "&nbsp;") + " - ");
        if (logEntry.getMessage() != null) {
            buffer.append("<i>").append(logEntry.getMessage()).append("</i>");
        }
        if (logEntry.getStackTrace() != null) {
            for (String line : StringUtils.split((String)logEntry.getStackTrace(), (String)"\n")) {
                buffer.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;" + StringUtils.formatAsHtml((String)line));
            }
        }
        buffer.append("</div>");
        return buffer.toString();
    }

    private static void addArgument(Commandline cmd, String name, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            cmd.addArgLine("-" + name);
            cmd.addArgValue(value);
        }
    }

    private String getExecutable() {
        return PluginSetting.getExecutablePath();
    }

    @Editable(name="Xcode project", order=900, description="Specifies the project name to build. Required if there are multiple project files in the same directory")
    @Scriptable
    @ScriptApi
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Editable(name="Target", order=1000, description="Specifies the target name to build")
    @Scriptable
    @ScriptApi
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Editable(name="Xcode workspace", order=1100, description="Specifies the workspace name to build")
    @Scriptable
    @ScriptApi
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    @Editable(name="Scheme", order=1200, description="Specifies the scheme name to build. Required if building a workspace")
    @Scriptable
    @ScriptApi
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Editable(name="Configuration", order=1400, description="Specifies the configuration name to be used when building each target")
    @Scriptable
    @ScriptApi
    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @Editable(name="Architecture", order=1500, description="Specifies the architecture when build each target")
    @Scriptable
    @ScriptApi
    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    @Editable(name="SDK", order=1600, description="Specifies the SDK when building an Xcode project or workspace. The argument can be an absolute path to an SDK, or the canonical name of an SDK")
    @Scriptable
    @ScriptApi
    public String getSdk() {
        return this.sdk;
    }

    public void setSdk(String sdk) {
        this.sdk = sdk;
    }

    @Editable(name="Additional Params", order=2000, description="Specifies any additional parameters you want.")
    @Scriptable
    @ScriptApi
    public String getAdditionalParams() {
        return this.additionalParams;
    }

    public void setAdditionalParams(String additionalParams) {
        this.additionalParams = additionalParams;
    }

    @Editable(name="Build Action(s)", order=2100, description="Specifies one or more build actions with space separated. By default, the actions are clean and build. The build actions can be: clean, build, test, archive, installsrc, install.")
    @Scriptable
    @ScriptApi
    public String getBuildActions() {
        return this.buildActions;
    }

    public void setBuildActions(String buildActions) {
        this.buildActions = buildActions;
    }
}

