/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.xcode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.log.Log;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XcodeLogger
extends LineConsumer {
    static final Pattern pTargetStart = Pattern.compile("^=== (BUILD|ARCHIVE|TEST|INSTALLSRC|INSTALL|CLEAN) TARGET (.*) ===");
    static final Pattern pTargetEnd = Pattern.compile("^\\*\\* (BUILD|ARCHIVE|TEST|INSTALLSRC|INSTALL|CLEAN) (FAILED|SUCCEEDED) \\*\\*");
    static final Pattern pInfo = Pattern.compile("^(\\d+) (warning|error)s? generated.");
    static final Pattern pSignError = Pattern.compile("^\\[BEROR\\](.*) error: (.*)");
    private List<String> block = Lists.newArrayList();
    List<String> errors = Lists.newArrayList();

    public void consume(String line) {
        if (Strings.isNullOrEmpty((String)line)) {
            this.logLines();
            this.block = Lists.newArrayList();
        } else {
            this.block.add(line);
        }
    }

    private void logLines() {
        if (this.block.isEmpty()) {
            Context.getLogger().info("");
        } else {
            String last;
            String msg = Joiner.on((String)"\n").join(this.block);
            Matcher m = pTargetEnd.matcher(msg);
            if (m.matches()) {
                String status = m.group(2);
                if (status.equals("FAILED")) {
                    this.errors.add(msg);
                    Context.getLogger().error(msg);
                } else {
                    Context.getLogger().info(msg);
                }
                return;
            }
            for (String each : this.block) {
                if (!each.contains(": error: ")) continue;
                this.errors.add(each);
                Context.getLogger().error(msg);
                return;
            }
            Log.LogLevel level = Log.LogLevel.INFO;
            for (String each : this.block) {
                if (!each.startsWith("[BEROR]")) continue;
                level = Log.LogLevel.ERROR;
                break;
            }
            if (level != Log.LogLevel.ERROR && (m = pInfo.matcher(last = (String)Iterables.getLast(this.block))).matches()) {
                String l = m.group(2);
                if (l.startsWith("warning")) {
                    level = Log.LogLevel.WARN;
                } else if (l.startsWith("error")) {
                    level = Log.LogLevel.ERROR;
                }
            }
            switch (level) {
                case WARN: {
                    Context.getLogger().warn(msg);
                    break;
                }
                case ERROR: {
                    this.errors.add(msg);
                    Context.getLogger().error(msg);
                    break;
                }
                default: {
                    Context.getLogger().info(msg);
                }
            }
            Context.getLogger().info("");
        }
    }

    public String getErrorMessage() {
        StringBuffer sb = new StringBuffer();
        int count = Math.min(5, this.errors.size());
        for (int i = 0; i < count; ++i) {
            sb.append(this.errors.get(i));
            if (i + 1 >= count) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

