/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web.jquery;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class JQTabbedPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private String options;
    private int activeTab = 0;
    final List<ITab> tabs;

    public JQTabbedPanel(String id, List<ITab> tabs) {
        this(id, tabs, "");
    }

    public JQTabbedPanel(String id, List<ITab> tabs, String options) {
        super(id);
        this.tabs = tabs;
        this.options = options == null ? "" : options;
        this.setDefaultModel((IModel)Model.of((Serializable)Integer.valueOf(this.activeTab)));
        final WebMarkupContainer parent = new WebMarkupContainer("tabs");
        parent.setOutputMarkupId(true);
        this.add(new Component[]{parent});
        if (!Strings.isNullOrEmpty((String)this.getCssClass())) {
            parent.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)this.getCssClass()))});
        }
        this.add(new Component[]{new Label("script", (IModel)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                String script = "$(document).ready(function() {var $tabs = $('#" + parent.getMarkupId() + "').tabs(); $tabs.tabs('select', " + JQTabbedPanel.this.activeTab + "); });";
                return script;
            }
        }).setEscapeModelStrings(false).setOutputMarkupId(true)});
        RepeatingView titles = new RepeatingView("tab");
        parent.add(new Component[]{titles});
        RepeatingView contents = new RepeatingView("content");
        parent.add(new Component[]{contents});
        for (int i = 0; i < tabs.size(); ++i) {
            final WebMarkupContainer content = tabs.get(i).getPanel(contents.newChildId());
            content.setOutputMarkupId(true);
            contents.add(new Component[]{content});
            WebMarkupContainer title = new WebMarkupContainer(titles.newChildId());
            title.setOutputMarkupId(true);
            final int index = i;
            title.add(new Component[]{new AjaxLink<Void>("link"){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("href", (CharSequence)("#" + content.getMarkupId()));
                    tag.put("onclick", (CharSequence)"return false;");
                }

                public void onClick(AjaxRequestTarget target) {
                    JQTabbedPanel.this.activeTab = index;
                }
            }.add(new Component[]{new Label("title", tabs.get(i).getTitle())})});
            titles.add(new Component[]{title});
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderCSSReference((ResourceReference)new PackageResourceReference(JQTabbedPanel.class, "jqTabs.css"));
    }

    public WebMarkupContainer getActivePanel() {
        return this.tabs.get(this.activeTab).getPanel("content");
    }

    protected String getTabsOptions() {
        return this.options;
    }

    protected String getCssClass() {
        return "";
    }
}

