/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web.jquery;

import com.google.common.base.Objects;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQTabbedPanel;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQueryLinkDecorator;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.WildcardListModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class JQLazyLoadTabbedPanel
extends Panel
implements IAjaxIndicatorAware {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer container = new WebMarkupContainer("tabs");
    private int selectedTabIndex;

    public JQLazyLoadTabbedPanel(String id, IModel<List<ITab>> tabModel) {
        super(id, tabModel);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
    }

    public Component getActivePanel() {
        return this.container.get("content");
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderCSSReference((ResourceReference)new PackageResourceReference(JQTabbedPanel.class, "jqTabs.css"));
    }

    public JQLazyLoadTabbedPanel(String id, List<ITab> tabs) {
        this(id, (IModel<List<ITab>>)new WildcardListModel(tabs));
    }

    protected void onInitialize() {
        super.onInitialize();
        List<ITab> tabs = this.getTabs();
        this.container.add(new Component[]{this.createNavigator(tabs)});
        if (tabs == null || tabs.size() == 0) {
            this.container.add(new Component[]{new WebMarkupContainer("content")});
            this.container.setVisible(false);
        } else if (this.selectedTabIndex < tabs.size()) {
            Panel activePanel = (Panel)tabs.get(this.selectedTabIndex).getPanel("content");
            this.container.add(new Component[]{activePanel});
        } else {
            this.selectedTabIndex = 0;
            this.container.add(new Component[]{tabs.get(0).getPanel("content")});
        }
    }

    private ListView<ITab> createNavigator(List<ITab> tabs) {
        ListView<ITab> navigator = new ListView<ITab>("tab", tabs){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<ITab> item) {
                ITab tab = (ITab)item.getModelObject();
                final int index = item.getIndex();
                item.setOutputMarkupId(true);
                item.add(new Component[]{new TabLink("link", tab, index)});
                String title = (String)tab.getTitle().getObject();
                final String css = "tab-" + title.replace(" ", "-").toLowerCase();
                item.add(new Behavior[]{new AttributeModifier("class", (IModel)new AbstractReadOnlyModel<String>(){
                    private static final long serialVersionUID = 1L;

                    public String getObject() {
                        if (JQLazyLoadTabbedPanel.this.selectedTabIndex == index) {
                            return "ui-tabs-selected";
                        }
                        return "";
                    }
                })});
                item.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){
                    private static final long serialVersionUID = 1L;

                    public String getObject() {
                        return css;
                    }
                })});
            }
        };
        navigator.setOutputMarkupId(true);
        return navigator;
    }

    private List<ITab> getTabs() {
        return (List)this.getDefaultModelObject();
    }

    public int getSelectedTabIndex() {
        return this.selectedTabIndex;
    }

    public JQLazyLoadTabbedPanel setSelectedTabIndex(int selectedTabIndex) {
        this.selectedTabIndex = selectedTabIndex;
        return this;
    }

    protected String getCssClass() {
        return "";
    }

    public void setActiveTab(String tabName) {
        List<ITab> tabs = this.getTabs();
        for (int i = 0; i < tabs.size(); ++i) {
            if (!Objects.equal((Object)tabName, (Object)tabs.get(i).getTitle().getObject())) continue;
            this.selectedTabIndex = i;
            break;
        }
    }

    public void selectTab(AjaxRequestTarget target, String tabName) {
        this.setActiveTab(tabName);
        this.container.addOrReplace(new Component[]{this.getTabs().get(this.selectedTabIndex).getPanel("content")});
        target.add(new Component[]{this.container.get("content")});
    }

    public String getAjaxIndicatorMarkupId() {
        return "global-ajax-indicator";
    }

    private class TabLink
    extends AjaxLink<Void> {
        private static final long serialVersionUID = 1L;
        private ITab tab;
        private final int tabIndex;

        public TabLink(String id, ITab tab, int tabIndex) {
            super(id);
            this.tab = tab;
            this.tabIndex = tabIndex;
            this.add(new Component[]{new Label("title", tab.getTitle())});
        }

        public void onClick(AjaxRequestTarget target) {
            JQLazyLoadTabbedPanel.this.selectedTabIndex = this.tabIndex;
            JQLazyLoadTabbedPanel.this.container.addOrReplace(new Component[]{this.tab.getPanel("content")});
            target.add(new Component[]{JQLazyLoadTabbedPanel.this.container.get("content")});
        }

        protected IAjaxCallDecorator getAjaxCallDecorator() {
            String script = "$('#" + JQLazyLoadTabbedPanel.this.container.getMarkupId() + " > ul > li').removeClass('ui-tabs-selected'); " + "$('#" + this.getParent().getMarkupId() + "').addClass('ui-tabs-selected');";
            return new JQueryLinkDecorator(script);
        }
    }
}

