/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web.feedback;

import java.util.HashSet;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.ComponentTag;

public class FeedbackStyle
extends Behavior {
    private static final long serialVersionUID = 1L;
    public static final FeedbackStyle INSTANCE = new FeedbackStyle();

    public void onComponentTag(Component c, ComponentTag tag) {
        List msgs = this.newFeedbackMessagesModel(c).getObject();
        if (msgs.size() > 0) {
            StringBuffer newClassValue = new StringBuffer(tag.getAttributes().getString("class", ""));
            HashSet<String> classes = new HashSet<String>();
            for (FeedbackMessage m : msgs) {
                String cssClass = this.getCssClass(m);
                if (!classes.add(cssClass)) continue;
                if (newClassValue.length() > 0) {
                    newClassValue.append(" ");
                }
                newClassValue.append(cssClass);
            }
            tag.put("class", (CharSequence)newClassValue.toString());
            tag.setModified(true);
        }
    }

    protected FeedbackMessagesModel newFeedbackMessagesModel(Component c) {
        FeedbackMessagesModel model = new FeedbackMessagesModel(c);
        if (c instanceof MarkupContainer) {
            model.setFilter((IFeedbackMessageFilter)new ContainerFeedbackMessageFilter((MarkupContainer)c));
        } else {
            model.setFilter((IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(c));
        }
        return model;
    }

    protected String getCssClass(FeedbackMessage msg) {
        return "feedback-" + msg.getLevelAsString().toLowerCase();
    }
}

