/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web.chart;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.pmease.quickbuild.plugin.report.engine.web.chart.XYChartData;
import java.util.ArrayList;
import java.util.Collections;
import org.jfree.data.xy.XYDataset;

public abstract class XYSeries
implements XYChartData {
    private final XYDataset[] datasets;

    public XYSeries(XYDataset[] datasets) {
        this.datasets = datasets;
    }

    @Override
    public XYDataset[] getDatasets() {
        return this.datasets;
    }

    @Override
    public boolean isEnabled(int index) {
        return true;
    }

    public XYDataset getPrimary() {
        return this.datasets[0];
    }

    @Override
    public Range<Double> getXRange() {
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < this.getPrimary().getItemCount(0); ++i) {
            values.add(this.getPrimary().getXValue(0, i));
        }
        Collections.sort(values);
        double lower = (Double)Iterables.getFirst((Iterable)values, (Object)0.0);
        double upper = (Double)Iterables.getLast((Iterable)values, (Object)0.0);
        double delta = upper - lower;
        lower = lower == 0.0 ? 0.0 : lower - delta / 10.0 * 0.05;
        return Range.closed((Comparable)Double.valueOf(lower), (Comparable)Double.valueOf(upper += delta / 10.0 * 0.05));
    }

    @Override
    public Range<Double> getYRange(int series) {
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < this.datasets[series].getItemCount(0); ++i) {
            values.add(this.datasets[series].getYValue(0, i));
        }
        Collections.sort(values);
        return Range.closed((Comparable)((Comparable)Iterables.getFirst((Iterable)values, (Object)0.0)), (Comparable)((Comparable)Iterables.getLast((Iterable)values, (Object)0.0)));
    }

    @Override
    public long getPoints(int index) {
        return this.datasets[index].getItemCount(0);
    }

    public double getXValue(int index, int item) {
        return this.datasets[index].getXValue(0, item);
    }

    public double getYValue(int index, int item) {
        return this.datasets[index].getYValue(0, item);
    }
}

