/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.web.ColorBar;
import com.pmease.quickbuild.web.component.dashboardpanel.StatsData;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class StackBarPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_COLOR = "#666666";

    public StackBarPanel(String id, IModel<List<? extends StatsData>> valuesModel) {
        super(id, valuesModel);
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer barspan = new WebMarkupContainer("bardiv");
        this.add(new Component[]{barspan});
        double totals = 0.0;
        List<StatsData> values = this.getValues();
        for (StatsData value : values) {
            totals += ((Number)value.getValue()).doubleValue();
        }
        final double t = totals;
        barspan.add(new Component[]{new ListView<StatsData>("bars", values){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<StatsData> item) {
                StatsData value = (StatsData)item.getModelObject();
                double d = t == 0.0 ? 0.0 : ((Number)value.getValue()).doubleValue() / t;
                String color = value.getColor();
                if (color == null) {
                    color = StackBarPanel.DEFAULT_COLOR;
                }
                ColorBar label = new ColorBar("barItem", d, color);
                item.add(new Component[]{label});
                item.setRenderBodyOnly(true);
            }
        }});
        barspan.add(new Behavior[]{AttributeModifier.replace((String)"title", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                ArrayList list = Lists.newArrayList();
                for (StatsData each : StackBarPanel.this.getValues()) {
                    list.add(each.getTitle() + ": " + each.formatData());
                }
                return Joiner.on((String)", ").skipNulls().join((Iterable)list);
            }
        })});
    }

    private List<StatsData> getValues() {
        return (List)this.getDefaultModelObject();
    }
}

