/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web;

import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.web.ColorBar;
import com.pmease.quickbuild.util.StringUtils;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ColorBarWithLabel
extends Panel {
    private static final long serialVersionUID = 1L;

    public ColorBarWithLabel(String id, double percent, String color, String labelString, boolean withLabel) {
        this(id, percent, color, labelString, null, withLabel);
    }

    public ColorBarWithLabel(String id, double percent, String color, String labelString, String labelTitle, boolean withLabel) {
        super(id);
        this.setOutputMarkupId(true);
        double ratio = 0.99;
        if (labelString != null) {
            this.add(new Component[]{new Label("barLabel", labelString).setVisible(withLabel).setEscapeModelStrings(false)});
        } else {
            this.add(new Component[]{new Label("barLabel", DataTypes.PERCENT.asString(percent, "#%")).setVisible(withLabel).setEscapeModelStrings(false)});
        }
        if (withLabel || !StringUtils.isEmpty((String)labelString)) {
            ratio = 0.65;
        }
        if (percent > 1.0) {
            percent = 1.0;
        }
        ColorBar bar = new ColorBar("barItem", percent * ratio, color);
        if (!StringUtils.isEmpty((String)labelTitle)) {
            bar.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)labelTitle)))});
        }
        this.add(new Component[]{bar});
    }
}

