/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web;

import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.util.StringUtils;
import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;

public class ColorBar
extends Label {
    private static final long serialVersionUID = 1L;
    private final double percent;
    private final String color;

    public ColorBar(String id, double percent, String color) {
        super(id);
        this.percent = percent;
        this.color = color;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        String style = "width: 0%;";
        if (!StringUtils.isEmpty((String)this.color)) {
            style = style + "background: " + this.color + ";";
        }
        tag.put("style", (CharSequence)style);
        if (this.percent > 0.0 && this.percent < 0.01) {
            tag.put("rel", (CharSequence)"1px");
        } else {
            tag.put("rel", (CharSequence)DataTypes.PERCENT.asString(this.percent, "0.0000%", Locale.US));
        }
        String cssClass = tag.getAttribute("class");
        if (cssClass == null) {
            cssClass = "";
        }
        tag.put("class", (CharSequence)("bar " + cssClass));
    }
}

