/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web;

import com.pmease.quickbuild.web.behavior.PopupBehavior;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.WildcardListModel;

public abstract class ChoicesLink<T extends Serializable>
extends Panel {
    private static final long serialVersionUID = 1L;
    private IModel<? extends List<? extends T>> choicesModel;

    public abstract void onChoiceChanged(AjaxRequestTarget var1, T var2);

    public ChoicesLink(String id, IModel<T> choiceModel, IModel<List<T>> choicesModel) {
        super(id, choiceModel);
        this.choicesModel = choicesModel;
    }

    public ChoicesLink(String id, IModel<T> choiceModel, List<? extends T> choices) {
        super(id, choiceModel);
        this.choicesModel = new WildcardListModel(choices);
    }

    public void onInitialize() {
        super.onInitialize();
        final Label label = new Label("label", this.getDefaultModel());
        label.setOutputMarkupId(true);
        this.add(new Component[]{label});
        label.add(new Behavior[]{new PopupBehavior(){
            private static final long serialVersionUID = 1L;

            protected Component getPopup(String componentId) {
                Fragment fragment = new Fragment(componentId, "acDropdownFrag", (MarkupContainer)ChoicesLink.this);
                fragment.add(new Component[]{new ListView<T>("choices", ChoicesLink.this.choicesModel){
                    private static final long serialVersionUID = 1L;

                    protected void populateItem(ListItem<T> item) {
                        final Serializable t = (Serializable)item.getModelObject();
                        AjaxLink<Void> link = new AjaxLink<Void>("choiceLink"){
                            private static final long serialVersionUID = 1L;

                            public void onClick(AjaxRequestTarget target) {
                                label.setDefaultModel((IModel)Model.of((Serializable)t));
                                target.add(new Component[]{label});
                                ChoicesLink.this.onChoiceChanged(target, t);
                            }
                        };
                        link.add(new Component[]{new Label("choiceLabel", item.getModel())});
                        item.add(new Component[]{link});
                    }
                }});
                return fragment;
            }
        }});
    }

    public void onDetach() {
        if (this.choicesModel != null) {
            this.choicesModel.detach();
        }
        super.onDetach();
    }
}

