/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.build.MoreBuildInfoPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;

public class BuildWithInfoPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private BuildFragment build;

    public BuildWithInfoPanel(String id, BuildFragment build) {
        super(id);
        this.build = build;
    }

    public void onInitialize() {
        super.onInitialize();
        WebMarkupContainer trigger = new WebMarkupContainer("trigger");
        if (this.build == null) {
            this.add(new Component[]{new Label("version", String.valueOf("N/A"))});
            this.add(new Component[]{trigger.setVisible(false)});
            this.add(new Component[]{new WebMarkupContainer("moreInfo").setVisible(false)});
        } else {
            Label label = new Label("version", ReportUtils.hyperlinkBuild(this.build));
            label.setEscapeModelStrings(false);
            this.add(new Component[]{label});
            this.add(new Component[]{trigger});
            trigger.add(new Behavior[]{new PopupBehavior(){

                protected Component getPopup(String componentId) {
                    BuildManager bm = (BuildManager)Quickbuild.getInstance(BuildManager.class);
                    Build reloaded = (Build)bm.get(BuildWithInfoPanel.this.build.getId());
                    if (reloaded != null) {
                        return new MoreBuildInfoPanel(componentId, reloaded);
                    }
                    return new EmptyPanel(componentId);
                }
            }.hoverMode(true)});
        }
    }
}

