/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.web;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Response;
import org.hibernate.Query;
import org.hibernate.Session;

public abstract class BuildChoice
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String NO_VERSION = "VERSION";

    public BuildChoice(String id, IModel model) {
        super(id);
        this.setRenderBodyOnly(true);
        final AutoCompleteTextField buildInput = new AutoCompleteTextField("acInput", model, new BuildChoiceRenderer()){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Iterator getChoices(String input) {
                Session session = SessionManager.openSession();
                try {
                    Query query = session.createQuery("select id, version, status from Build where configuration.id=:configurationId and id<:buildId and (lower(version) like :version)order by id desc");
                    Build build = Context.getBuild();
                    query.setParameter("configurationId", (Object)build.getConfiguration().getId());
                    query.setParameter("buildId", (Object)build.getId());
                    query.setParameter("version", (Object)(input + "%"));
                    query.setMaxResults(10);
                    List result = query.list();
                    ArrayList<BuildFragment> builds = new ArrayList<BuildFragment>();
                    for (Object[] objects : result) {
                        BuildFragment frag = new BuildFragment();
                        frag.setId((Long)objects[0]);
                        frag.setVersion((String)objects[1]);
                        frag.setStatus((Build.Status)objects[2]);
                        builds.add(frag);
                    }
                    Iterator iterator = builds.iterator();
                    return iterator;
                }
                finally {
                    SessionManager.closeSession();
                }
            }
        };
        buildInput.add(new Behavior[]{new AttributeModifier("class", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                String version = (String)buildInput.getModelObject();
                if (StringUtils.isBlank((String)version) || version.equalsIgnoreCase(BuildChoice.NO_VERSION)) {
                    return "choices-input no-build";
                }
                return "choices-input";
            }
        })});
        this.add(new Component[]{buildInput});
        AjaxLink link = new AjaxLink("shortcutLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
            }
        };
        link.add(new Behavior[]{new PopupBehavior(){

            protected Component getPopup(String componentId) {
                Fragment fragment = new Fragment(componentId, "acDropdownFrag", (MarkupContainer)BuildChoice.this);
                fragment.add(new Component[]{new AjaxLink("latestSuccessful"){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        BuildChoice.this.OnShortcut(BuildShortcut.PREVIOUS_SUCCESSFUL, target);
                    }
                }.setEnabled(BuildUtils.getPrevious(Build.Status.SUCCESSFUL) != null)});
                fragment.add(new Component[]{new AjaxLink("latestFailed"){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        BuildChoice.this.OnShortcut(BuildShortcut.PREVIOUS_FAILED, target);
                    }
                }.setEnabled(BuildUtils.getPrevious(Build.Status.FAILED) != null)});
                fragment.add(new Component[]{new AjaxLink("latestRecommended"){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        BuildChoice.this.OnShortcut(BuildShortcut.LATEST_RECOMMENDED, target);
                    }
                }.setEnabled(BuildUtils.getPrevious(Build.Status.RECOMMENDED) != null)});
                fragment.add(new Component[]{new AjaxLink("noComparing"){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        BuildChoice.this.OnShortcut(BuildShortcut.NO_COMPARE, target);
                    }
                }});
                return fragment;
            }
        }});
        this.add(new Component[]{link});
    }

    protected abstract void OnShortcut(BuildShortcut var1, AjaxRequestTarget var2);

    protected abstract CharSequence getBuildChangedJavascript(BuildFragment var1);

    private class BuildChoiceRenderer
    implements IAutoCompleteRenderer<BuildFragment> {
        private static final long serialVersionUID = 1L;

        private BuildChoiceRenderer() {
        }

        public void renderHeader(Response response) {
            response.write((CharSequence)"<ul class=\"build-choices\">");
        }

        public void render(BuildFragment object, Response response, String criteria) {
            String textValue = object.getVersion();
            if (textValue == null) {
                throw new IllegalStateException("A call to textValue(Object) returned an illegal value: null for object: " + object.toString());
            }
            textValue = textValue.replaceAll("\\\"", "&quot;");
            response.write((CharSequence)("<li textvalue=\"" + textValue + "\""));
            CharSequence handler = this.getOnSelectJavascriptExpression(object);
            if (handler != null) {
                response.write((CharSequence)(" onselect=\"" + handler + '\"'));
            }
            response.write((CharSequence)">");
            response.write((CharSequence)"<div ");
            response.write((CharSequence)(" class=\"build-status " + object.getStatus().name().toLowerCase() + "\">"));
            response.write((CharSequence)textValue);
            response.write((CharSequence)"</div>");
            response.write((CharSequence)"</li>");
        }

        public void renderFooter(Response response, int count) {
            response.write((CharSequence)"</ul>");
        }

        protected CharSequence getOnSelectJavascriptExpression(BuildFragment item) {
            return null;
        }
    }

    public static enum BuildShortcut {
        PREVIOUS_SUCCESSFUL,
        LATEST_RECOMMENDED,
        PREVIOUS_FAILED,
        NO_COMPARE,
        ALL_BUILDS;

    }
}

