/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util.quantity;

import com.pmease.quickbuild.plugin.report.engine.util.quantity.Unit;
import java.util.concurrent.TimeUnit;

public enum Time implements Unit<Time>
{
    NANOSECONDS(1.0, TimeUnit.NANOSECONDS, "ns"),
    MICROSECONDS(1000.0, NANOSECONDS, TimeUnit.MICROSECONDS, "us"),
    MILLISECONDS(1000.0, MICROSECONDS, TimeUnit.MILLISECONDS, "ms"),
    SECONDS(1000.0, MILLISECONDS, TimeUnit.SECONDS, "secs"),
    MINUTES(60.0, SECONDS, TimeUnit.MINUTES, "mins"),
    HOURS(60.0, MINUTES, TimeUnit.HOURS, "hrs"),
    DAYS(24.0, HOURS, TimeUnit.DAYS, "days");

    private final double multiplier;
    private final TimeUnit timeUnit;
    private final String display;

    private Time(double multiplier, TimeUnit timeUnit, String display) {
        this.multiplier = multiplier;
        this.timeUnit = timeUnit;
        this.display = display;
    }

    private Time(double multiplier, Time base, TimeUnit timeUnit, String display) {
        this(multiplier * base.multiplier, timeUnit, display);
    }

    @Override
    public double multiplier() {
        return this.multiplier;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String toString() {
        return this.display;
    }
}

