/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util.quantity;

import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.util.quantity.Amount;
import com.pmease.quickbuild.plugin.report.engine.util.quantity.Unit;

public enum Data implements Unit<Data>
{
    BITS(1.0),
    Kb(1024.0, BITS),
    Mb(1024.0, Kb),
    Gb(1024.0, Mb),
    BYTES(8.0, BITS),
    KB(1024.0, BYTES),
    MB(1024.0, KB),
    GB(1024.0, MB),
    TB(1024.0, GB),
    PB(1024.0, TB);

    private final double multiplier;

    private Data(double multiplier) {
        this.multiplier = multiplier;
    }

    private Data(double multiplier, Data base) {
        this(multiplier * base.multiplier);
    }

    @Override
    public double multiplier() {
        return this.multiplier;
    }

    public static String formatBytes(double bytes) {
        return Data.formatBytes(bytes, "#");
    }

    public static String formatBytes(double bytes, String pattern) {
        Amount<Double, Data> amount = Amount.of(bytes, BYTES);
        for (int i = Data.values().length - 1; i >= 0; --i) {
            Data unit = Data.values()[i];
            double d = amount.as(unit);
            if (!(d >= 1.0)) continue;
            return DataTypes.DOUBLE.asString(d, pattern) + unit.name();
        }
        return "0";
    }
}

