/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util.quantity;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.plugin.report.engine.util.quantity.Unit;
import com.pmease.quickbuild.util.Pair;

public abstract class Amount<T extends Number, U extends Unit<U>>
implements Comparable<Amount<T, U>> {
    private final Pair<T, U> amount;

    private Amount(T value, U unit) {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull(unit);
        this.amount = new Pair(value, unit);
    }

    public T getValue() {
        return (T)((Number)this.amount.getFirst());
    }

    public U getUnit() {
        return (U)((Unit)this.amount.getSecond());
    }

    public T as(U unit) {
        return this.asUnit((Unit<?>)unit);
    }

    private T asUnit(Unit<?> unit) {
        return this.sameUnits(unit) ? this.getValue() : this.scale(this.getUnit().multiplier() / unit.multiplier());
    }

    public int hashCode() {
        return this.amount.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Amount)) {
            return false;
        }
        Amount other = (Amount)obj;
        return this.amount.equals(other.amount) || this.isSameAmount(other);
    }

    private boolean isSameAmount(Amount<?, ?> other) {
        Object value = other.getValue();
        if (!this.getValue().getClass().isInstance(value)) {
            return false;
        }
        Object unit = other.getUnit();
        if (!this.getUnit().getClass().isInstance(unit)) {
            return false;
        }
        Object otherUnit = other.getUnit();
        return this.isSameAmount(other, otherUnit);
    }

    private boolean isSameAmount(Amount<?, ?> other, U otherUnit) {
        if (otherUnit.multiplier() > this.getUnit().multiplier()) {
            return this.getValue().equals(super.asUnit((Unit<?>)this.getUnit()));
        }
        return this.as(otherUnit).equals(other.getValue());
    }

    public String toString() {
        return this.amount.toString();
    }

    @Override
    public int compareTo(Amount<T, U> other) {
        if (other.getUnit().multiplier() > this.getUnit().multiplier()) {
            return ((Comparable)this.getValue()).compareTo(other.as(this.getUnit()));
        }
        return ((Comparable)this.as(other.getUnit())).compareTo(other.getValue());
    }

    private boolean sameUnits(Unit<? extends Unit<?>> unit) {
        return this.getUnit().equals(unit);
    }

    protected abstract T scale(double var1);

    public static <U extends Unit<U>> Amount<Double, U> of(double number, U unit) {
        return new Amount<Double, U>(number, unit){

            @Override
            protected Double scale(double multiplier) {
                return (Double)this.getValue() * multiplier;
            }
        };
    }

    public static <U extends Unit<U>> Amount<Float, U> of(float number, U unit) {
        return new Amount<Float, U>(Float.valueOf(number), unit){

            @Override
            protected Float scale(double multiplier) {
                return Float.valueOf((float)((double)((Float)this.getValue()).floatValue() * multiplier));
            }
        };
    }

    public static <U extends Unit<U>> Amount<Long, U> of(long number, U unit) {
        return new Amount<Long, U>(number, unit){

            @Override
            protected Long scale(double multiplier) {
                return (long)((double)((Long)this.getValue()).longValue() * multiplier);
            }
        };
    }

    public static <U extends Unit<U>> Amount<Integer, U> of(int number, U unit) {
        return new Amount<Integer, U>(number, unit){

            @Override
            protected Integer scale(double multiplier) {
                return (int)((double)((Integer)this.getValue()).intValue() * multiplier);
            }
        };
    }

    /* synthetic */ Amount(Number x0, Unit x1, 1 x2) {
        this(x0, x1);
    }
}

