/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util.csv;

import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVEscape;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;

public class CSVWriter {
    private final Writer writer;
    private final char commentChar;
    private final char delimiter;
    private final String lineSeparator;

    public CSVWriter(Writer writer) {
        this(writer, ',', '#');
    }

    public CSVWriter(Writer writer, char delimiter) {
        this(writer, delimiter, '#');
    }

    public CSVWriter(Writer writer, char delimiter, char comment) {
        this.writer = writer;
        this.delimiter = delimiter;
        this.commentChar = comment;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void writeCommentLine(String comment) throws IOException {
        String[] lines;
        for (String line : lines = comment.split("[\r\n]")) {
            this.writer.write(this.commentChar);
            this.writer.write(32);
            this.writer.write(line);
            this.writer.write(this.lineSeparator);
        }
    }

    public void writeHeaderLine(SortedMap<String, String> fields) throws IOException {
        this.writeLine(fields.keySet());
    }

    public void writeDataLine(SortedMap<String, String> fields) throws IOException {
        this.writeLine(fields.values());
    }

    public void writeLine(List<String> values) throws IOException {
        this.writeLine((Collection<String>)values);
    }

    public void writeLine(String[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            CSVEscape.escapeCSV(this.writer, values[ii], this.delimiter);
            if (ii + 1 >= values.length) continue;
            this.writer.append(this.delimiter);
        }
        this.writer.write(this.lineSeparator);
    }

    private void writeLine(Collection<String> values) throws IOException {
        int ii = 0;
        for (String value : values) {
            CSVEscape.escapeCSV(this.writer, value, this.delimiter);
            if (++ii >= values.size()) continue;
            this.writer.append(this.delimiter);
        }
        this.writer.write(this.lineSeparator);
    }

    public void join(Collection<String> values) throws IOException {
        int ii = 0;
        for (String value : values) {
            CSVEscape.escapeCSV(this.writer, value, this.delimiter);
            if (++ii >= values.size()) continue;
            this.writer.append(this.delimiter);
        }
    }
}

