/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util.csv;

import com.pmease.quickbuild.plugin.report.engine.exception.ParseException;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CSVTokenizer
implements ListIterator<String> {
    private final List<String> tokens;
    private int tokenPos = 0;

    public CSVTokenizer(String line) throws ParseException {
        this.tokens = new CSVParser().tokenize(line);
    }

    @Override
    public void add(String o) {
        throw new UnsupportedOperationException("add() is unsupported");
    }

    @Override
    public boolean hasNext() {
        return this.tokenPos < this.tokens.size();
    }

    @Override
    public boolean hasPrevious() {
        return this.tokenPos > 0;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            return this.tokens.get(this.tokenPos++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.tokenPos;
    }

    @Override
    public String previous() {
        if (this.hasPrevious()) {
            return this.tokens.get(--this.tokenPos);
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.tokenPos - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported");
    }

    @Override
    public void set(String o) {
        throw new UnsupportedOperationException("set() is unsupported");
    }

    public void reset() {
        this.tokenPos = 0;
    }
}

